/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.WordCastValue;
import org.qbicc.type.PointerType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class DecodeReference
extends AbstractValue
implements WordCastValue,
OrderedNode {
    private final Node dependency;
    private final Value reference;
    private final PointerType valueType;

    DecodeReference(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value reference, PointerType valueType) {
        super(callSite, element, line, bci);
        OrderedNode on;
        while (dependency instanceof OrderedNode && !(on = (OrderedNode)dependency).maySafePoint()) {
            dependency = on.getDependency();
        }
        this.dependency = dependency;
        this.reference = reference;
        this.valueType = valueType;
    }

    @Override
    public boolean isNullable() {
        return this.reference.isNullable();
    }

    @Override
    int calcHashCode() {
        return Objects.hash(DecodeReference.class, this.dependency, this.reference);
    }

    @Override
    String getNodeName() {
        return "DecodeReference";
    }

    @Override
    public boolean equals(Object other) {
        DecodeReference dr;
        return other instanceof DecodeReference && this.equals(dr = (DecodeReference)other);
    }

    public boolean equals(DecodeReference other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.reference.equals(other.reference);
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public Value getInput() {
        return this.reference;
    }

    @Override
    public PointerType getType() {
        return this.valueType;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.getInput().toReferenceString(b);
        b.append(')');
        b.append(" to ");
        this.valueType.toString(b);
        return b;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

