/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.CastValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Util;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class CheckCast
extends AbstractValue
implements CastValue,
OrderedNode {
    private final Node dependency;
    private final Value input;
    private final Value toType;
    private final Value toDimensions;
    private final ReferenceType type;
    private final CastType kind;
    private final ObjectType expectedType;

    CheckCast(Node callSite, ExecutableElement element, int line, int bci, Node dependency, Value input, Value toType, Value toDimensions, CastType kind, ObjectType expectedType) {
        super(callSite, element, line, bci);
        this.dependency = dependency;
        this.input = input;
        this.toType = toType;
        this.toDimensions = toDimensions;
        this.expectedType = expectedType;
        this.type = ((ReferenceType)input.getType()).narrow(expectedType);
        this.kind = kind;
    }

    @Override
    public Node getDependency() {
        return this.dependency;
    }

    @Override
    public boolean maySafePoint() {
        return true;
    }

    @Override
    public Value getInput() {
        return this.input;
    }

    public Value getToType() {
        return this.toType;
    }

    public Value getToDimensions() {
        return this.toDimensions;
    }

    public ObjectType getExpectedType() {
        return this.expectedType;
    }

    @Override
    public ReferenceType getType() {
        return this.type;
    }

    public CastType getKind() {
        return this.kind;
    }

    @Override
    public int getValueDependencyCount() {
        return 3;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return this.input;
            }
            case 1: {
                return this.toType;
            }
            case 2: {
                return this.toDimensions;
            }
        }
        return (Value)Util.throwIndexOutOfBounds(index);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    int calcHashCode() {
        return Objects.hash(new Object[]{CheckCast.class, this.dependency, this.input, this.toType, this.toDimensions, this.kind, this.type});
    }

    @Override
    String getNodeName() {
        return "CheckCast";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof CheckCast && this.equals((CheckCast)other);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append(':');
        b.append((Object)this.kind);
        b.append('(');
        this.getInput().toReferenceString(b);
        b.append(')');
        b.append(" to ");
        this.toType.toReferenceString(b);
        return b;
    }

    public boolean equals(CheckCast other) {
        return this == other || other != null && this.dependency.equals(other.dependency) && this.input.equals(other.input) && this.toType.equals(other.toType) && this.toDimensions.equals(other.toDimensions) && this.kind.equals((Object)other.kind) && this.type.equals(other.type);
    }

    public static enum CastType {
        ArrayStore,
        Cast;


        public String toString() {
            return this.equals((Object)ArrayStore) ? "storecheck" : "checkcast";
        }
    }
}

