/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.List;
import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.InvocationNode;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.type.InvokableType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class CallNoSideEffects
extends AbstractValue
implements InvocationNode {
    private final Value target;
    private final Value receiver;
    private final List<Value> arguments;
    private final InvokableType calleeType;

    CallNoSideEffects(Node callSite, ExecutableElement element, int line, int bci, Value target, Value receiver, List<Value> arguments) {
        super(callSite, element, line, bci);
        this.target = target;
        this.receiver = receiver;
        this.arguments = arguments;
        this.calleeType = (InvokableType)target.getPointeeType();
    }

    @Override
    int calcHashCode() {
        return Objects.hash(CallNoSideEffects.class, this.target, this.receiver, this.arguments);
    }

    @Override
    String getNodeName() {
        return "CallNoSideEffects";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof CallNoSideEffects && this.equals((CallNoSideEffects)other);
    }

    public boolean equals(CallNoSideEffects other) {
        return this == other || other != null && this.target.equals(other.target) && this.receiver.equals(other.receiver) && this.arguments.equals(other.arguments);
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        return InvocationNode.toRValueString(this, "call", b).append(" no-side-effects");
    }

    @Override
    public InvokableType getCalleeType() {
        return this.calleeType;
    }

    @Override
    public ValueType getType() {
        return this.getCalleeType().getReturnType();
    }

    @Override
    public List<Value> getArguments() {
        return this.arguments;
    }

    @Override
    public Value getTarget() {
        return this.target;
    }

    @Override
    public Value getReceiver() {
        return this.receiver;
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    @Override
    public boolean isConstant() {
        for (Value argument : this.arguments) {
            if (argument.isConstant()) continue;
            return false;
        }
        return true;
    }
}

