/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Objects;
import org.qbicc.graph.AbstractValue;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.type.PointerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.ExecutableElement;

public final class ByteOffsetPointer
extends AbstractValue {
    private final Value base;
    private final Value offset;
    private final ValueType outputType;

    ByteOffsetPointer(Node callSite, ExecutableElement element, int line, int bci, Value base, Value offset, ValueType outputType) {
        super(callSite, element, line, bci);
        this.base = base;
        this.offset = offset;
        this.outputType = outputType;
    }

    @Override
    public int getValueDependencyCount() {
        return 2;
    }

    @Override
    public Value getValueDependency(int index) throws IndexOutOfBoundsException {
        return switch (index) {
            case 0 -> this.base;
            case 1 -> this.offset;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public PointerType getType() {
        return this.outputType.getPointer();
    }

    @Override
    public boolean isConstant() {
        return this.offset.isConstant() && this.base.isConstant();
    }

    @Override
    public boolean isPointeeConstant() {
        return false;
    }

    @Override
    public AccessMode getDetectedMode() {
        return this.base.getDetectedMode();
    }

    public Value getBasePointer() {
        return this.base;
    }

    public Value getOffset() {
        return this.offset;
    }

    public ValueType getOutputType() {
        return this.getPointeeType();
    }

    @Override
    int calcHashCode() {
        return Objects.hash(this.base, this.offset, this.outputType);
    }

    @Override
    String getNodeName() {
        return "ByteOffsetPointer";
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ByteOffsetPointer && this.equals((ByteOffsetPointer)other);
    }

    @Override
    StringBuilder toRValueString(StringBuilder b) {
        return this.offset.toReferenceString(this.base.toReferenceString(b.append("offset ")).append(" by bytes "));
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append('(');
        this.offset.toReferenceString(b);
        b.append(')');
        return b;
    }

    public boolean equals(ByteOffsetPointer other) {
        return this == other || other != null && this.base.equals(other.base) && this.offset.equals(other.offset) && this.outputType.equals(other.offset);
    }

    @Override
    public <T, R> R accept(ValueVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }
}

