/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import org.qbicc.graph.BasicBlock;

public final class BlockLabel {
    private Object target;

    public BasicBlock setTarget(BasicBlock target) {
        if (target.getHandleIfExists() == null) {
            target.setHandle(this);
        }
        this.target = target;
        return target;
    }

    public BlockLabel setTarget(BlockLabel target) {
        if (target == this) {
            return target;
        }
        Object oldTarget = this.target;
        if (oldTarget instanceof BlockLabel) {
            ((BlockLabel)oldTarget).setTarget(target);
        } else {
            this.target = target;
        }
        return target;
    }

    public BlockLabel lastHandle() {
        Object target = this.target;
        if (target instanceof BlockLabel) {
            return ((BlockLabel)target).lastHandle();
        }
        if (target == null || target instanceof BasicBlock) {
            return this;
        }
        throw new IllegalStateException();
    }

    public boolean hasTarget() {
        return this.lastHandle().target instanceof BasicBlock;
    }

    public static BlockLabel of(BasicBlock node) {
        return node == null ? null : node.getHandle().lastHandle();
    }

    public static BasicBlock getTargetOf(BlockLabel handle) {
        return handle == null ? null : (BasicBlock)handle.lastHandle().target;
    }

    public String toString() {
        Object target = this.target;
        if (target == null) {
            return "empty";
        }
        if (target instanceof BlockLabel) {
            return "fwd to " + target;
        }
        return "-> " + target;
    }
}

