/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import org.qbicc.graph.AbstractNode;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.type.VoidType;
import org.qbicc.type.definition.element.ExecutableElement;

abstract class AbstractValue
extends AbstractNode
implements Value {
    private boolean usedInSuccessor;

    AbstractValue(Node callSite, ExecutableElement element, int line, int bci) {
        super(callSite, element, line, bci);
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        if (this.getType() instanceof VoidType) {
            return this.toRValueString(b);
        }
        return this.toRValueString(this.toLValueString(b).append(" = "));
    }

    StringBuilder toLValueString(StringBuilder b) {
        BasicBlock block = this.getScheduledBlock();
        b.append('%');
        if (block != null) {
            int idx = this.getScheduleIndex();
            block.toString(b);
            b.append('.');
            if (idx >= 0) {
                b.append(idx);
            } else {
                b.append("??");
            }
        } else {
            b.append("??");
        }
        return b;
    }

    StringBuilder toRValueString(StringBuilder b) {
        return super.toString(b);
    }

    @Override
    public StringBuilder toReferenceString(StringBuilder b) {
        return this.toLValueString(b);
    }
}

