/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.graph;

import java.util.Set;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.type.definition.element.ExecutableElement;

abstract class AbstractNode
implements Node {
    private final Node callSite;
    private final ExecutableElement element;
    private final int line;
    private final int bci;
    private int hashCode;
    private int scheduleIndex = -1;
    private BasicBlock scheduledBlock;
    private Set<Value> liveIns;
    private Set<Value> liveOuts;

    AbstractNode(Node callSite, ExecutableElement element, int line, int bci) {
        this.callSite = callSite;
        this.element = element;
        this.line = line;
        this.bci = bci;
    }

    @Override
    public Node getCallSite() {
        return this.callSite;
    }

    @Override
    public ExecutableElement getElement() {
        return this.element;
    }

    @Override
    public int getSourceLine() {
        return this.line;
    }

    @Override
    public int getBytecodeIndex() {
        return this.bci;
    }

    @Override
    public int getScheduleIndex() {
        return this.scheduleIndex;
    }

    @Override
    public void setScheduleIndex(int index) {
        this.scheduleIndex = index;
    }

    @Override
    public Set<Value> getLiveIns() {
        return this.liveIns;
    }

    @Override
    public void setLiveIns(Set<Value> liveIns) {
        this.liveIns = liveIns;
    }

    @Override
    public Set<Value> getLiveOuts() {
        return this.liveOuts;
    }

    @Override
    public void setLiveOuts(Set<Value> liveOuts) {
        this.liveOuts = liveOuts;
    }

    @Override
    public BasicBlock getScheduledBlock() {
        return this.scheduledBlock;
    }

    @Override
    public void setScheduledBlock(BasicBlock block) {
        this.scheduledBlock = block;
    }

    abstract int calcHashCode();

    abstract String getNodeName();

    public abstract boolean equals(Object var1);

    public final String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        b.append(this.getNodeName());
        return b;
    }

    public final int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = this.calcHashCode();
            if (hashCode == 0) {
                hashCode = Integer.MIN_VALUE;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }
}

