/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.facts;

import java.util.function.ObjLongConsumer;
import org.qbicc.facts.Fact;
import org.qbicc.facts.Facts;

public abstract class Condition<F extends Fact<?>> {
    Condition() {
    }

    public static <F extends Fact<?>> Condition<F> when(F fact) {
        return new Of<F>(fact);
    }

    public static <F extends Fact<?>> Condition<F> whenAll(F fact1, F fact2) {
        return new All2<F>(fact1, fact2);
    }

    public static <F extends Fact<?>> Condition<F> whenAll(F fact1, F fact2, F fact3) {
        return new All3<F>(fact1, fact2, fact3);
    }

    @SafeVarargs
    public static <F extends Fact<?>> Condition<F> whenAll(F ... facts) {
        return new AllMany(facts);
    }

    public static <F extends Fact<?>> Condition<F> whenAny(F fact1, F fact2) {
        return new Any2<F>(fact1, fact2);
    }

    public static <F extends Fact<?>> Condition<F> whenAny(F fact1, F fact2, F fact3) {
        return new Any3<F>(fact1, fact2, fact3);
    }

    @SafeVarargs
    public static <F extends Fact<?>> Condition<F> whenAny(F ... facts) {
        return new AnyMany(facts);
    }

    public Condition<F> and(Condition<F> other) {
        return new And<F>(this, other);
    }

    public Condition<F> or(Condition<F> other) {
        return new Or<F>(this, other);
    }

    abstract ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> var1);

    static class Of<F extends Fact<?>>
    extends Condition<F> {
        final F fact1;

        Of(F fact1) {
            this.fact1 = fact1;
        }

        @Override
        ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> next) {
            return (holder, bits) -> next.accept((Facts)holder, bits | 1L << holder.getFactIndex((Fact<?>)this.fact1));
        }
    }

    static class All2<F extends Fact<?>>
    extends Of<F> {
        final F fact2;

        All2(F fact1, F fact2) {
            super(fact1);
            this.fact2 = fact2;
        }

        @Override
        ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> next) {
            return (holder, bits) -> next.accept((Facts)holder, bits | 1L << holder.getFactIndex(this.fact1) | 1L << holder.getFactIndex((Fact<?>)this.fact2));
        }
    }

    static class All3<F extends Fact<?>>
    extends All2<F> {
        final F fact3;

        All3(F fact1, F fact2, F fact3) {
            super(fact1, fact2);
            this.fact3 = fact3;
        }

        @Override
        ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> next) {
            return (holder, bits) -> next.accept((Facts)holder, bits | 1L << holder.getFactIndex(this.fact1) | 1L << holder.getFactIndex(this.fact2) | 1L << holder.getFactIndex((Fact<?>)this.fact3));
        }
    }

    static class AllMany<F extends Fact<?>>
    extends Condition<F> {
        final F[] facts;

        AllMany(F[] facts) {
            this.facts = facts;
        }

        @Override
        ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> next) {
            return (holder, bits) -> {
                for (F fact : this.facts) {
                    bits |= 1L << holder.getFactIndex((Fact<?>)fact);
                }
                next.accept((Facts)holder, bits);
            };
        }
    }

    static class Any2<F extends Fact<?>>
    extends Of<F> {
        final F fact2;

        Any2(F fact1, F fact2) {
            super(fact1);
            this.fact2 = fact2;
        }

        @Override
        ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> next) {
            return (holder, bits) -> {
                next.accept((Facts)holder, bits | 1L << holder.getFactIndex(this.fact1));
                next.accept((Facts)holder, bits | 1L << holder.getFactIndex((Fact<?>)this.fact2));
            };
        }
    }

    static class Any3<F extends Fact<?>>
    extends Any2<F> {
        final F fact3;

        Any3(F fact1, F fact2, F fact3) {
            super(fact1, fact2);
            this.fact3 = fact3;
        }

        @Override
        ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> next) {
            return (holder, bits) -> {
                next.accept((Facts)holder, bits | 1L << holder.getFactIndex(this.fact1));
                next.accept((Facts)holder, bits | 1L << holder.getFactIndex(this.fact2));
                next.accept((Facts)holder, bits | 1L << holder.getFactIndex((Fact<?>)this.fact3));
            };
        }
    }

    static class AnyMany<F extends Fact<?>>
    extends Condition<F> {
        final F[] facts;

        AnyMany(F[] facts) {
            this.facts = facts;
        }

        @Override
        ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> next) {
            return (holder, bits) -> {
                for (F fact : this.facts) {
                    next.accept((Facts)holder, bits | 1L << holder.getFactIndex((Fact<?>)fact));
                }
            };
        }
    }

    static class And<F extends Fact<?>>
    extends Condition<F> {
        private final Condition<F> cond1;
        private final Condition<F> cond2;

        And(Condition<F> cond1, Condition<F> cond2) {
            this.cond1 = cond1;
            this.cond2 = cond2;
        }

        @Override
        ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> next) {
            return this.cond1.getRegisterFunction(this.cond2.getRegisterFunction(next));
        }
    }

    static class Or<F extends Fact<?>>
    extends Condition<F> {
        private final Condition<F> cond1;
        private final Condition<F> cond2;

        Or(Condition<F> cond1, Condition<F> cond2) {
            this.cond1 = cond1;
            this.cond2 = cond2;
        }

        @Override
        ObjLongConsumer<Facts> getRegisterFunction(ObjLongConsumer<Facts> next) {
            ObjLongConsumer<Facts> f1 = this.cond1.getRegisterFunction(next);
            ObjLongConsumer<Facts> f2 = this.cond2.getRegisterFunction(next);
            return (holder, bits) -> {
                f1.accept((Facts)holder, bits);
                f2.accept((Facts)holder, bits);
            };
        }
    }
}

