/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.context;

import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.context.DiagnosticContext;
import org.qbicc.facts.Facts;
import org.qbicc.facts.core.ExecutableReachabilityFacts;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.schedule.Scheduler;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.machine.arch.Platform;
import org.qbicc.object.Function;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.Section;
import org.qbicc.type.FunctionType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.NativeMethodConfigurator;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.MemberElement;

public interface CompilationContext
extends DiagnosticContext {
    public static final String IMPLICIT_SECTION_NAME = "__implicit__";

    public Platform getPlatform();

    public TypeSystem getTypeSystem();

    public Scheduler getScheduler();

    public LiteralFactory getLiteralFactory();

    public ClassContext getBootstrapClassContext();

    default public ClassContext getClassContextForLoader(VmClassLoader classLoaderObject) {
        return classLoaderObject == null ? this.getBootstrapClassContext() : classLoaderObject.getClassContext();
    }

    public ClassContext constructClassContext(VmClassLoader var1);

    public ClassContext constructAppClassLoaderClassContext(VmClassLoader var1);

    public ClassContext constructPlatformClassContext(VmClassLoader var1);

    public <T> void submitTask(T var1, Consumer<T> var2);

    default public void enqueue(ExecutableElement element) {
        Facts.get(this).discover(element, ExecutableReachabilityFacts.IS_INVOKED);
    }

    default public boolean wasEnqueued(ExecutableElement element) {
        return Facts.get(this).isDiscovered(element, ExecutableReachabilityFacts.IS_INVOKED);
    }

    default public boolean mayBeEnqueued(ExecutableElement element) {
        Facts facts = Facts.get(this);
        return !facts.hasPreviousFacts() || facts.hadFact(element, ExecutableReachabilityFacts.IS_INVOKED);
    }

    default public int numberEnqueued() {
        return (int)Facts.get(this).getDiscoveredCount(ExecutableReachabilityFacts.IS_INVOKED);
    }

    public NativeMethodConfigurator getNativeMethodConfigurator();

    public void registerEntryPoint(ExecutableElement var1);

    public Path getOutputDirectory();

    public Path getOutputFile(DefinedTypeDefinition var1, String var2);

    public Path getOutputDirectory(DefinedTypeDefinition var1);

    public Path getOutputDirectory(MemberElement var1);

    default public ProgramModule getOrAddProgramModule(MemberElement element) {
        return this.getOrAddProgramModule(element.getEnclosingType());
    }

    public ProgramModule getOrAddProgramModule(DefinedTypeDefinition var1);

    public List<ProgramModule> getAllProgramModules();

    public DefinedTypeDefinition getDefaultTypeDefinition();

    public ModuleSection getImplicitSection(ExecutableElement var1);

    public ModuleSection getImplicitSection(DefinedTypeDefinition var1);

    public Section getImplicitSection();

    public Function getExactFunction(ExecutableElement var1);

    public Function getExactFunctionIfExists(ExecutableElement var1);

    public FunctionElement establishExactFunction(ExecutableElement var1, FunctionElement var2);

    public FunctionType getFunctionTypeForInvokableType(InvokableType var1);

    public FunctionType getFunctionTypeForElement(ExecutableElement var1);

    public FunctionType getFunctionTypeForInitializer();

    public Vm getVm();

    public void setTaskRunner(BiConsumer<Consumer<CompilationContext>, CompilationContext> var1) throws IllegalStateException;

    public void runWrappedTask(Consumer<CompilationContext> var1);

    public void runParallelTask(Consumer<CompilationContext> var1) throws IllegalStateException;

    public BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>> getCopier();
}

