/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.context;

import java.nio.ByteBuffer;
import java.util.List;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.type.Primitive;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.DescriptorTypeResolver;
import org.qbicc.type.definition.MethodTypeId;
import org.qbicc.type.definition.TypeId;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;

public interface ClassContext
extends DescriptorTypeResolver {
    public CompilationContext getCompilationContext();

    public VmClassLoader getClassLoader();

    public DefinedTypeDefinition findDefinedType(String var1);

    public DefinedTypeDefinition.Builder newTypeBuilder();

    public String deduplicate(ByteBuffer var1, int var2, int var3);

    public String deduplicate(String var1);

    public MethodTypeId resolveMethodType(MethodDescriptor var1);

    default public TypeId resolveDescriptor(TypeDescriptor descriptor) {
        if (descriptor instanceof ClassTypeDescriptor) {
            ClassTypeDescriptor ctd = (ClassTypeDescriptor)descriptor;
            String className = ctd.getPackageName() + "/" + ctd.getClassName();
            DefinedTypeDefinition definedType = this.findDefinedType(className);
            return definedType == null ? null : definedType.typeId();
        }
        if (descriptor instanceof BaseTypeDescriptor) {
            BaseTypeDescriptor btd = (BaseTypeDescriptor)descriptor;
            return this.getCompilationContext().getVm().getPrimitiveClass(Primitive.getPrimitiveFor(btd)).getTypeDefinition().typeId();
        }
        if (descriptor instanceof ArrayTypeDescriptor) {
            ArrayTypeDescriptor atd = (ArrayTypeDescriptor)descriptor;
            TypeDescriptor etd = atd.getElementTypeDescriptor();
            if (etd instanceof BaseTypeDescriptor) {
                BaseTypeDescriptor btd = (BaseTypeDescriptor)etd;
                return this.getCompilationContext().getVm().getPrimitiveClass(Primitive.getPrimitiveFor(btd)).getArrayClass().getTypeDefinition().typeId();
            }
            return this.resolveDescriptor(etd).getArrayTypeId();
        }
        throw new IllegalStateException();
    }

    public TypeSystem getTypeSystem();

    public LiteralFactory getLiteralFactory();

    public BasicBlockBuilder newBasicBlockBuilder(BasicBlockBuilder.FactoryContext var1, ExecutableElement var2);

    default public BasicBlockBuilder newBasicBlockBuilder(ExecutableElement element) {
        return this.newBasicBlockBuilder(BasicBlockBuilder.FactoryContext.EMPTY, element);
    }

    public void defineClass(String var1, DefinedTypeDefinition var2);

    @Override
    public ValueType resolveTypeFromDescriptor(TypeDescriptor var1, TypeParameterContext var2, TypeSignature var3);

    public byte[] getResource(String var1);

    public List<byte[]> getResources(String var1);

    public boolean isBootstrap();
}

