/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.python.compiler.Code;
import org.python.core.Py;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.objectweb.asm.Type;
import org.python.util.Generic;

public class ProxyCodeHelpers {
    public static final int tBoolean = 0;
    public static final int tByte = 1;
    public static final int tShort = 2;
    public static final int tInteger = 3;
    public static final int tLong = 4;
    public static final int tFloat = 5;
    public static final int tDouble = 6;
    public static final int tCharacter = 7;
    public static final int tVoid = 8;
    public static final int tOther = 9;
    public static final int tNone = 10;
    public static Map<Class<?>, Integer> types = ProxyCodeHelpers.fillTypes();

    public static Map<Class<?>, Integer> fillTypes() {
        Map<Class<?>, Integer> typeMap = Generic.map();
        typeMap.put(Boolean.TYPE, 0);
        typeMap.put(Byte.TYPE, 1);
        typeMap.put(Short.TYPE, 2);
        typeMap.put(Integer.TYPE, 3);
        typeMap.put(Long.TYPE, 4);
        typeMap.put(Float.TYPE, 5);
        typeMap.put(Double.TYPE, 6);
        typeMap.put(Character.TYPE, 7);
        typeMap.put(Void.TYPE, 8);
        return typeMap;
    }

    public static int getType(Class<?> c) {
        if (c == null) {
            return 10;
        }
        Integer i = types.get(c);
        if (i == null) {
            return 9;
        }
        return i;
    }

    public static PyObject findPython(PyProxy proxy, String name) {
        PyObject ret;
        PyObject o = proxy._getPyInstance();
        if (o == null) {
            proxy.__initProxy__(new Object[0]);
            o = proxy._getPyInstance();
        }
        if ((ret = o.__findattr__(name)) instanceof PyMethod) {
            PyMethod meth = (PyMethod)ret;
            if (meth.__func__ instanceof PyReflectedFunction) {
                PyReflectedFunction func = (PyReflectedFunction)meth.__func__;
                if (func.nargs > 0 && proxy.getClass() == func.argslist[0].declaringClass) {
                    return null;
                }
            }
        }
        Py.setSystemState(proxy._getPySystemState());
        return ret;
    }

    public static String mapClass(Class<?> c) {
        String name = c.getName();
        int index = name.indexOf(".");
        if (index == -1) {
            return name;
        }
        StringBuffer buf = new StringBuffer(name.length());
        int last_index = 0;
        while (index != -1) {
            buf.append(name.substring(last_index, index));
            buf.append("/");
            last_index = index + 1;
            index = name.indexOf(".", last_index);
        }
        buf.append(name.substring(last_index, name.length()));
        return buf.toString();
    }

    public static String mapType(Class<?> type) {
        if (type.isArray()) {
            return "[" + ProxyCodeHelpers.mapType(type.getComponentType());
        }
        switch (ProxyCodeHelpers.getType(type)) {
            case 1: {
                return "B";
            }
            case 7: {
                return "C";
            }
            case 6: {
                return "D";
            }
            case 5: {
                return "F";
            }
            case 3: {
                return "I";
            }
            case 4: {
                return "J";
            }
            case 2: {
                return "S";
            }
            case 0: {
                return "Z";
            }
            case 8: {
                return "V";
            }
        }
        return "L" + ProxyCodeHelpers.mapClass(type) + ";";
    }

    public static String makeSig(Class<?> ret, Class<?> ... sig) {
        String[] mapped = new String[sig.length];
        for (int i = 0; i < mapped.length; ++i) {
            mapped[i] = ProxyCodeHelpers.mapType(sig[i]);
        }
        return ProxyCodeHelpers.makeSig(ProxyCodeHelpers.mapType(ret), mapped);
    }

    public static String makeSig(String returnType, String ... parameterTypes) {
        StringBuilder buf = new StringBuilder("(");
        for (String param : parameterTypes) {
            buf.append(param);
        }
        return buf.append(')').append(returnType).toString();
    }

    public static void doReturn(Code code2, Class<?> type) throws Exception {
        switch (ProxyCodeHelpers.getType(type)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code2.ireturn();
                break;
            }
            case 4: {
                code2.lreturn();
                break;
            }
            case 5: {
                code2.freturn();
                break;
            }
            case 6: {
                code2.dreturn();
                break;
            }
            case 8: {
                code2.return_();
                break;
            }
            default: {
                code2.areturn();
            }
        }
    }

    public static void doNullReturn(Code code2, Class<?> type) throws Exception {
        switch (ProxyCodeHelpers.getType(type)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code2.iconst_0();
                code2.ireturn();
                break;
            }
            case 4: {
                code2.lconst_0();
                code2.lreturn();
                break;
            }
            case 5: {
                code2.fconst_0();
                code2.freturn();
                break;
            }
            case 6: {
                code2.dconst_0();
                code2.dreturn();
                break;
            }
            case 8: {
                code2.return_();
                break;
            }
            default: {
                code2.aconst_null();
                code2.areturn();
            }
        }
    }

    public static String[] mapClasses(Class<?>[] classes) {
        String[] mapped = new String[classes.length];
        for (int i = 0; i < mapped.length; ++i) {
            mapped[i] = ProxyCodeHelpers.mapClass(classes[i]);
        }
        return mapped;
    }

    public static String[] mapExceptions(Class<?>[] classes) {
        String[] exceptionTypes = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            exceptionTypes[i] = Type.getType(classes[i]).getInternalName();
        }
        return exceptionTypes;
    }

    public static class AnnotationDescr {
        public final Class<?> annotation;
        public final Map<String, Object> fields;

        public AnnotationDescr(Class<?> annotation) {
            this.annotation = annotation;
            this.fields = null;
        }

        public AnnotationDescr(Class<?> annotation, Map<String, Object> fields) {
            this.annotation = annotation;
            this.fields = fields;
        }

        public boolean hasFields() {
            return this.fields != null;
        }

        public String getName() {
            return ProxyCodeHelpers.mapType(this.annotation);
        }

        public Map<String, Object> getFields() {
            return this.fields;
        }

        public int hashCode() {
            if (this.hasFields()) {
                int hash = this.annotation.hashCode();
                for (Map.Entry<String, Object> field : this.fields.entrySet()) {
                    hash += field.getKey().hashCode() + field.getValue().hashCode();
                }
                return hash;
            }
            return this.annotation.hashCode();
        }
    }

    public static class ConstructorDescr
    extends MethodDescr {
        public ConstructorDescr(Constructor<?> cons) {
            this(cons.getParameterTypes(), cons.getExceptionTypes());
        }

        public ConstructorDescr(Class<?>[] parameters, Class<?>[] exceptions2) {
            super("<init>", Void.TYPE, parameters, exceptions2);
        }
    }

    public static class MethodDescr {
        public final Class<?> returnType;
        public final String name;
        public final Class<?>[] parameters;
        public final Class<?>[] exceptions;
        public final Map<String, Object> methodAnnotations;
        public final Map<String, Object>[] parameterAnnotations;

        public MethodDescr(Method m) {
            this(m.getName(), m.getReturnType(), m.getParameterTypes(), m.getExceptionTypes(), null, null);
        }

        public MethodDescr(String name, Class<?> returnType, Class<?>[] parameters, Class<?>[] exceptions2) {
            this.name = name;
            this.returnType = returnType;
            this.parameters = parameters;
            this.exceptions = exceptions2;
            this.methodAnnotations = null;
            this.parameterAnnotations = null;
        }

        public MethodDescr(String name, Class<?> returnType, Class<?>[] parameters, Class<?>[] exceptions2, Map<String, Object> methodAnnotations, Map<String, Object>[] parameterAnnotations) {
            this.name = name;
            this.returnType = returnType;
            this.parameters = parameters;
            this.exceptions = exceptions2;
            this.methodAnnotations = methodAnnotations;
            this.parameterAnnotations = parameterAnnotations;
        }

        public int hashCode() {
            return this.name.hashCode() + this.parameters.length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodDescr)) {
                return false;
            }
            MethodDescr oDescr = (MethodDescr)obj;
            if (!this.name.equals(oDescr.name) || this.parameters.length != oDescr.parameters.length) {
                return false;
            }
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i].equals(oDescr.parameters[i])) continue;
                return false;
            }
            return true;
        }
    }
}

