/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.pushingpixels.trident.api.TimelineEngine;
import org.pushingpixels.trident.api.interpolator.PropertyInterpolator;
import org.pushingpixels.trident.api.interpolator.PropertyInterpolatorSource;
import org.pushingpixels.trident.internal.interpolator.CorePropertyInterpolators;
import org.pushingpixels.trident.internal.swing.AWTPropertyInterpolators;

public class TridentCortex {
    private static Set<PropertyInterpolator<?>> propertyInterpolators = new HashSet();
    private static PulseSource currPulseSource = new DefaultPulseSource();

    private TridentCortex() {
    }

    public static Collection<PropertyInterpolator<?>> getPropertyInterpolators() {
        return Collections.unmodifiableSet(propertyInterpolators);
    }

    public static <T> PropertyInterpolator<T> getPropertyInterpolator(Collection<T> values) {
        for (PropertyInterpolator<?> interpolator : propertyInterpolators) {
            try {
                Class<?> basePropertyClass = interpolator.getBasePropertyClass();
                boolean hasMatch = true;
                for (T value : values) {
                    if (basePropertyClass.isAssignableFrom(value.getClass())) continue;
                    hasMatch = false;
                }
                if (!hasMatch) continue;
                return interpolator;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        return null;
    }

    public static void addPropertyInterpolator(PropertyInterpolator<?> pInterpolator) {
        propertyInterpolators.add(pInterpolator);
    }

    public static void addPropertyInterpolatorSource(PropertyInterpolatorSource pInterpolatorSource) {
        propertyInterpolators.addAll(pInterpolatorSource.getPropertyInterpolators());
    }

    public static void removePropertyInterpolator(PropertyInterpolator<?> pInterpolator) {
        propertyInterpolators.remove(pInterpolator);
    }

    public static void setPulseSource(PulseSource pulseSource) {
        TimelineEngine.TridentAnimationThread current = TimelineEngine.getInstance().animatorThread;
        if (current != null && current.isAlive()) {
            throw new IllegalStateException("Cannot replace the pulse source thread once it's running");
        }
        currPulseSource = pulseSource;
    }

    public static PulseSource getPulseSource() {
        return currPulseSource;
    }

    static {
        propertyInterpolators.addAll(new CorePropertyInterpolators().getPropertyInterpolators());
        propertyInterpolators.addAll(new AWTPropertyInterpolators().getPropertyInterpolators());
    }

    private static class DefaultPulseSource
    extends FixedRatePulseSource {
        DefaultPulseSource() {
            super(40);
        }
    }

    public static class FixedRatePulseSource
    implements PulseSource {
        private int msDelay;

        public FixedRatePulseSource(int msDelay) {
            this.msDelay = msDelay;
        }

        @Override
        public void waitUntilNextPulse() {
            try {
                Thread.sleep(this.msDelay);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public static interface PulseSource {
        public void waitUntilNextPulse();
    }
}

