/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.BaseDarkColorScheme;
import org.pushingpixels.substance.api.colorscheme.BaseLightColorScheme;
import org.pushingpixels.substance.api.colorscheme.BottleGreenColorScheme;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunGlareColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunfireRedColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceTitleButton;

public class SubstanceColorSchemeUtilities {
    private static final LazyResettableHashMap<SubstanceColorScheme> shiftedCache = new LazyResettableHashMap("ShiftColorScheme.shiftedSchemes");
    public static final SubstanceColorScheme YELLOW = new SunGlareColorScheme();
    public static final SubstanceColorScheme ORANGE = new SunfireRedColorScheme();
    public static final SubstanceColorScheme GREEN = new BottleGreenColorScheme();

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme scheme, boolean isEnabled) {
        Component forQuerying = component;
        if (component != null && component.getParent() != null && (component.getClass().isAnnotationPresent(SubstanceInternalArrowButton.class) || component instanceof SubstanceTitleButton)) {
            forQuerying = component.getParent();
        }
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, scheme, forQuerying == null ? null : forQuerying.getForeground(), forQuerying == null ? null : forQuerying.getBackground(), isEnabled);
    }

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme scheme, Color fgColor, Color bgColor, boolean isEnabled) {
        if (scheme != null && component != null) {
            if (bgColor instanceof UIResource) {
                bgColor = null;
            }
            if (fgColor instanceof UIResource) {
                fgColor = null;
            }
            if (bgColor != null || fgColor != null) {
                double colorization = SubstanceCoreUtilities.getColorizationFactor(component);
                if (!isEnabled) {
                    colorization /= 2.0;
                }
                if (colorization > 0.0) {
                    return SubstanceColorSchemeUtilities.getShiftedScheme(scheme, bgColor, colorization, fgColor, colorization);
                }
            }
        }
        return scheme;
    }

    public static SubstanceColorScheme getColorScheme(JTabbedPane jtp, int tabIndex, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(jtp);
        if (skin == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(jtp, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(jtp, associationKind, componentState);
        if (tabIndex >= 0) {
            Component component = jtp.getComponentAt(tabIndex);
            SubstanceColorScheme colorized = SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, jtp.getForegroundAt(tabIndex), jtp.getBackgroundAt(tabIndex), !componentState.isDisabled());
            return colorized;
        }
        return SubstanceColorSchemeUtilities.getColorizedScheme(jtp, nonColorized, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getColorScheme(Component component, ComponentState componentState) {
        SubstanceSkin skin;
        boolean isButtonThatIsNeverPainted;
        Component orig = component;
        boolean bl = isButtonThatIsNeverPainted = component instanceof AbstractButton && SubstanceCoreUtilities.isButtonNeverPainted((AbstractButton)component);
        if (isButtonThatIsNeverPainted || SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        if ((skin = SubstanceCoreUtilities.getSkin(component)) == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(component, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(component, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(orig, nonColorized, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getColorScheme(Component component, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        SubstanceSkin skin;
        if (!(component instanceof JToolBar) && SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        if ((skin = SubstanceCoreUtilities.getSkin(component)) == null) {
            return null;
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(component, associationKind, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getDirectColorScheme(Component component, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (!(component instanceof JToolBar) && SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        SubstanceColorScheme nonColorized = SubstanceCoreUtilities.getSkin(component).getDirectColorScheme(component, associationKind, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getActiveColorScheme(Component component, ComponentState componentState) {
        if (!(component instanceof JToolBar) && SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        SubstanceColorScheme nonColorized = SubstanceCoreUtilities.getSkin(component).getActiveColorScheme(SubstanceCortex.ComponentOrParentChainScope.getDecorationType(component));
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, !componentState.isDisabled());
    }

    public static float getHighlightAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getHighlightAlpha(component, componentState);
    }

    public static float getAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getAlpha(component, componentState);
    }

    public static SubstanceColorScheme getLightColorScheme(String name, final Color[] colors) {
        if (colors == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colors.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseLightColorScheme(name){

            @Override
            public Color getUltraLightColor() {
                return colors[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colors[1];
            }

            @Override
            public Color getLightColor() {
                return colors[2];
            }

            @Override
            public Color getMidColor() {
                return colors[3];
            }

            @Override
            public Color getDarkColor() {
                return colors[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colors[5];
            }

            @Override
            public Color getForegroundColor() {
                return colors[6];
            }
        };
    }

    public static SubstanceColorScheme getDarkColorScheme(String name, final Color[] colors) {
        if (colors == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colors.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseDarkColorScheme(name){

            @Override
            public Color getUltraLightColor() {
                return colors[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colors[1];
            }

            @Override
            public Color getLightColor() {
                return colors[2];
            }

            @Override
            public Color getMidColor() {
                return colors[3];
            }

            @Override
            public Color getDarkColor() {
                return colors[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colors[5];
            }

            @Override
            public Color getForegroundColor() {
                return colors[6];
            }
        };
    }

    public static SubstanceSkin.ColorSchemes getColorSchemes(URL url) {
        ArrayList<SubstanceColorScheme> schemes;
        block39: {
            schemes = new ArrayList<SubstanceColorScheme>();
            Color ultraLight = null;
            Color extraLight = null;
            Color light = null;
            Color mid = null;
            Color dark = null;
            Color ultraDark = null;
            Color foreground = null;
            String name = null;
            ColorSchemeKind kind = null;
            boolean inColorSchemeBlock = false;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                String line;
                block40: {
                    while (true) {
                        if ((line = reader.readLine()) == null) {
                            break block39;
                        }
                        if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                        if (line.indexOf("{") >= 0) {
                            if (inColorSchemeBlock) {
                                throw new IllegalArgumentException("Already in color scheme definition");
                            }
                            inColorSchemeBlock = true;
                            name = line.substring(0, line.indexOf("{")).trim();
                            continue;
                        }
                        if (line.indexOf("}") >= 0) {
                            if (!inColorSchemeBlock) {
                                throw new IllegalArgumentException("Not in color scheme definition");
                            }
                            inColorSchemeBlock = false;
                            if (name == null || kind == null || ultraLight == null || extraLight == null || light == null || mid == null || dark == null || ultraDark == null || foreground == null) {
                                throw new IllegalArgumentException("Incomplete specification");
                            }
                            Color[] colors = new Color[]{ultraLight, extraLight, light, mid, dark, ultraDark, foreground};
                            if (kind == ColorSchemeKind.LIGHT) {
                                schemes.add(SubstanceColorSchemeUtilities.getLightColorScheme(name, colors));
                            } else {
                                schemes.add(SubstanceColorSchemeUtilities.getDarkColorScheme(name, colors));
                            }
                            name = null;
                            kind = null;
                            ultraLight = null;
                            extraLight = null;
                            light = null;
                            mid = null;
                            dark = null;
                            ultraDark = null;
                            foreground = null;
                            continue;
                        }
                        String[] split = line.split("=");
                        if (split.length != 2) {
                            throw new IllegalArgumentException("Unsupported format in line " + line);
                        }
                        String key = split[0].trim();
                        String value = split[1].trim();
                        if ("kind".equals(key)) {
                            if (kind == null) {
                                if ("Light".equals(value)) {
                                    kind = ColorSchemeKind.LIGHT;
                                    continue;
                                }
                                if ("Dark".equals(value)) {
                                    kind = ColorSchemeKind.DARK;
                                    continue;
                                }
                                throw new IllegalArgumentException("Unsupported format in line " + line);
                            }
                            throw new IllegalArgumentException("'kind' should only be defined once");
                        }
                        if ("colorUltraLight".equals(key)) {
                            if (ultraLight == null) {
                                ultraLight = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'ultraLight' should only be defined once");
                        }
                        if ("colorExtraLight".equals(key)) {
                            if (extraLight == null) {
                                extraLight = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'extraLight' should only be defined once");
                        }
                        if ("colorLight".equals(key)) {
                            if (light == null) {
                                light = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'light' should only be defined once");
                        }
                        if ("colorMid".equals(key)) {
                            if (mid == null) {
                                mid = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'mid' should only be defined once");
                        }
                        if ("colorDark".equals(key)) {
                            if (dark == null) {
                                dark = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'dark' should only be defined once");
                        }
                        if ("colorUltraDark".equals(key)) {
                            if (ultraDark == null) {
                                ultraDark = Color.decode(value);
                                continue;
                            }
                            throw new IllegalArgumentException("'ultraDark' should only be defined once");
                        }
                        if (!"colorForeground".equals(key)) break block40;
                        if (foreground != null) break;
                        foreground = Color.decode(value);
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once");
                }
                throw new IllegalArgumentException("Unsupported format in line " + line);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
        return new SubstanceSkin.ColorSchemes(schemes);
    }

    public static SubstanceColorScheme getShiftedScheme(SubstanceColorScheme orig, Color backgroundShiftColor, double backgroundShiftFactor, Color foregroundShiftColor, double foregroundShiftFactor) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(orig.getDisplayName(), backgroundShiftColor == null ? "" : Integer.valueOf(backgroundShiftColor.getRGB()), backgroundShiftFactor, foregroundShiftColor == null ? "" : Integer.valueOf(foregroundShiftColor.getRGB()), foregroundShiftFactor);
        SubstanceColorScheme result = shiftedCache.get(key);
        if (result == null) {
            result = orig.shift(backgroundShiftColor, backgroundShiftFactor, foregroundShiftColor, foregroundShiftFactor);
            shiftedCache.put(key, result);
        }
        return result;
    }

    private static enum ColorSchemeKind {
        LIGHT,
        DARK;

    }
}

