/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.internal.utils.SubstanceColorResource;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceSpinnerButton;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class SubstanceSpinnerUI
extends BasicSpinnerUI {
    private PropertyChangeListener substancePropertyChangeListener;
    private SubstanceSpinnerButton nextButton;
    private SubstanceSpinnerButton prevButton;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceSpinnerUI();
    }

    private SubstanceSpinnerUI() {
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("substancelaf.internal.textComponentAware", new SubstanceCoreUtilities.TextComponentAware<JSpinner>(){

            @Override
            public JTextComponent getTextComponent(JSpinner t) {
                JComponent editor = t.getEditor();
                if (editor != null && editor instanceof JSpinner.DefaultEditor) {
                    return ((JSpinner.DefaultEditor)editor).getTextField();
                }
                return null;
            }
        });
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.putClientProperty("substancelaf.internal.textComponentAware", null);
        super.uninstallUI(c);
    }

    @Override
    protected Component createNextButton() {
        this.nextButton = new SubstanceSpinnerButton(this.spinner, 1);
        this.nextButton.setFont(this.spinner.getFont());
        this.nextButton.setName("Spinner.nextButton");
        TransitionAwareIcon icon = new TransitionAwareIcon(this.nextButton, scheme -> {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.nextButton);
            return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSpinnerArrowIconWidth(fontSize), SubstanceSizeUtils.getSpinnerArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize), 1, scheme);
        }, "substance.spinner.nextButton");
        this.nextButton.setIcon(icon);
        int spinnerButtonSize = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.spinner));
        this.nextButton.setPreferredSize(new Dimension(spinnerButtonSize, spinnerButtonSize));
        this.nextButton.setMinimumSize(new Dimension(5, 5));
        this.installNextButtonListeners(this.nextButton);
        Color spinnerBg = this.spinner.getBackground();
        if (!(spinnerBg instanceof UIResource)) {
            this.nextButton.setBackground(spinnerBg);
        }
        return this.nextButton;
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = new SubstanceSpinnerButton(this.spinner, 5);
        this.prevButton.setFont(this.spinner.getFont());
        this.prevButton.setName("Spinner.previousButton");
        TransitionAwareIcon icon = new TransitionAwareIcon(this.prevButton, scheme -> {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.prevButton);
            float spinnerArrowIconHeight = SubstanceSizeUtils.getSpinnerArrowIconHeight(fontSize);
            return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSpinnerArrowIconWidth(fontSize), spinnerArrowIconHeight, SubstanceSizeUtils.getArrowStrokeWidth(fontSize), 5, scheme);
        }, "substance.spinner.prevButton");
        this.prevButton.setIcon(icon);
        int spinnerButtonSize = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.prevButton));
        this.prevButton.setPreferredSize(new Dimension(spinnerButtonSize, spinnerButtonSize));
        this.prevButton.setMinimumSize(new Dimension(5, 5));
        this.installPreviousButtonListeners(this.prevButton);
        Color spinnerBg = this.spinner.getBackground();
        if (!(spinnerBg instanceof UIResource)) {
            this.nextButton.setBackground(spinnerBg);
        }
        return this.prevButton;
    }

    @Override
    protected void installDefaults() {
        Border b;
        JFormattedTextField tf;
        super.installDefaults();
        JComponent editor = this.spinner.getEditor();
        if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.spinner);
            Insets ins = SubstanceSizeUtils.getSpinnerTextBorderInsets(fontSize);
            tf.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
            tf.setFont(this.spinner.getFont());
            tf.setOpaque(false);
        }
        if (editor != null) {
            editor.setOpaque(false);
        }
        if ((b = this.spinner.getBorder()) == null || b instanceof UIResource) {
            SubstanceTextComponentBorder border = new SubstanceTextComponentBorder(SubstanceSizeUtils.getSpinnerBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.spinner)));
            this.spinner.setBorder(border);
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = evt -> {
            if ("editor".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    JFormattedTextField tf;
                    if (this.spinner == null) {
                        return;
                    }
                    JComponent editor = this.spinner.getEditor();
                    if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
                        Insets ins = SubstanceSizeUtils.getSpinnerTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.spinner));
                        tf.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
                        tf.revalidate();
                    }
                });
            }
            if ("font".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.spinner != null) {
                        this.spinner.updateUI();
                    }
                });
            }
            if ("background".equals(evt.getPropertyName())) {
                JFormattedTextField tf;
                JComponent editor = this.spinner.getEditor();
                if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
                    Color tfBackground = tf.getBackground();
                    boolean canReplace = SubstanceCoreUtilities.canReplaceChildBackgroundColor(tfBackground);
                    if (this.spinner.getBackground() == null) {
                        canReplace = false;
                    }
                    if (canReplace) {
                        tf.setBackground(new SubstanceColorResource(this.spinner.getBackground()));
                    }
                }
                this.nextButton.setBackground(this.spinner.getBackground());
                this.prevButton.setBackground(this.spinner.getBackground());
            }
        };
        this.spinner.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        SubstanceTextUtilities.paintTextCompBackground(g, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension nextD = this.nextButton.getPreferredSize();
        Dimension previousD = this.prevButton.getPreferredSize();
        Dimension editorD = this.spinner.getEditor().getPreferredSize();
        Dimension size = new Dimension(editorD.width, editorD.height);
        size.width += Math.max(nextD.width, previousD.width);
        Insets insets = this.spinner.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    @Override
    protected LayoutManager createLayout() {
        return new SpinnerLayoutManager();
    }

    protected class SpinnerLayoutManager
    implements LayoutManager {
        protected SpinnerLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = SubstanceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension previousD = SubstanceSpinnerUI.this.prevButton.getPreferredSize();
            Dimension editorD = SubstanceSpinnerUI.this.spinner.getEditor().getPreferredSize();
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            Insets buttonInsets = SubstanceSizeUtils.getSpinnerArrowButtonInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
            size.width += buttonInsets.left + buttonInsets.right;
            return size;
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            Dimension nextD = SubstanceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension previousD = SubstanceSpinnerUI.this.prevButton.getPreferredSize();
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = SubstanceSizeUtils.getSpinnerArrowButtonInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth;
                buttonsX = width - buttonsWidth;
            } else {
                buttonsX = 0;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - editorX - insets.right;
            }
            int nextY = 0;
            int nextHeight = height / 2 + height % 2 - nextY;
            int previousY = 0 * buttonInsets.top + nextHeight;
            int previousHeight = height - previousY;
            SubstanceSpinnerUI.this.spinner.getEditor().setBounds(editorX, insets.top, editorWidth, editorHeight);
            SubstanceSpinnerUI.this.nextButton.setBounds(buttonsX, nextY, buttonsWidth, nextHeight);
            SubstanceSpinnerUI.this.prevButton.setBounds(buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }
}

