/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstancePanelUI
extends BasicPanelUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstancePanelUI();
    }

    private SubstancePanelUI() {
    }

    @Override
    protected void installDefaults(JPanel p) {
        Color backgroundFillColor;
        super.installDefaults(p);
        Color backgr = p.getBackground();
        if ((backgr == null || backgr instanceof UIResource) && (backgroundFillColor = SubstanceColorUtilities.getBackgroundFillColor(p)) != null) {
            p.setBackground(new ColorUIResource(backgroundFillColor));
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (this.toPaintBackground(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
        super.paint(g, c);
        GhostPaintingUtils.paintGhostImages(c, g);
    }

    private boolean toPaintBackground(JComponent c) {
        return SubstanceCoreUtilities.isOpaque(c);
    }
}

