/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverMenuItemListener;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenu;

public class SubstanceMenuItemUI
extends BasicMenuItemUI
implements SubstanceMenu,
TransitionAwareUI {
    private StateTransitionTracker stateTransitionTracker;
    private MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;
    private RolloverMenuItemListener substanceRolloverListener;
    private PropertyChangeListener substancePropertyListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceMenuItemUI((JMenuItem)comp);
    }

    private SubstanceMenuItemUI(JMenuItem menuItem) {
        this.stateTransitionTracker = new StateTransitionTracker(menuItem, menuItem.getModel());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.substanceRolloverListener = new RolloverMenuItemListener(this.menuItem, this.stateTransitionTracker);
        this.menuItem.addMouseListener(this.substanceRolloverListener);
        this.stateTransitionTracker.registerModelListeners();
        this.substancePropertyListener = evt -> {
            if ("model".equals(evt.getPropertyName())) {
                this.stateTransitionTracker.setModel((ButtonModel)evt.getNewValue());
            }
            if ("font".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.menuItem != null) {
                        this.menuItem.updateUI();
                    }
                });
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.defaultTextIconGap = SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(this.menuItem));
    }

    @Override
    public void updateCheckIconIfNeeded() {
    }

    @Override
    protected void uninstallListeners() {
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners();
    }

    @Override
    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    @Override
    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    @Override
    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    @Override
    public Icon getCheckIcon() {
        return null;
    }

    @Override
    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        return new Dimension(MenuUtilities.getPreferredWidth(this.menuItem), superDim.height);
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        MenuUtilities.paintMenuItem(g, this.menuItem, checkIcon, arrowIcon, defaultTextIconGap);
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return this.menuItem.getBounds().contains(me.getX(), me.getY());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }
}

