/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.animation.ModificationAwareUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.ButtonVisualStateTracker;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostingListener;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.swing.SwingComponentTimeline;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class SubstanceButtonUI
extends BasicButtonUI
implements TransitionAwareUI,
ModificationAwareUI {
    public static final String BORDER_COMPUTED = "substancelaf.buttonbordercomputed";
    public static final String BORDER_COMPUTING = "substancelaf.buttonbordercomputing";
    static final String BORDER_ORIGINAL = "substancelaf.buttonborderoriginal";
    private static final String ICON_ORIGINAL = "substancelaf.buttoniconoriginal";
    static final String OPACITY_ORIGINAL = "substancelaf.buttonopacityoriginal";
    static final String LOCK_OPACITY = "substancelaf.lockopacity";
    public static final String IS_TITLE_CLOSE_BUTTON = "substancelaf.internal.isTitleCloseButton";
    private ButtonBackgroundDelegate delegate;
    private GlowingIcon glowingIcon;
    private PropertyChangeListener substancePropertyListener;
    private ButtonVisualStateTracker substanceVisualStateTracker;
    private GhostingListener ghostModelChangeListener;
    private Set<SubstanceWidget> lafWidgets;
    protected AbstractButton button;
    private Timeline modifiedTimeline;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceButtonUI((AbstractButton)comp);
    }

    private SubstanceButtonUI(AbstractButton button) {
        this.button = button;
        this.delegate = new ButtonBackgroundDelegate();
    }

    @Override
    public void installUI(JComponent c) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (b.getClientProperty(BORDER_ORIGINAL) == null) {
            b.putClientProperty(BORDER_ORIGINAL, b.getBorder());
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty(BORDER_COMPUTED) == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty(OPACITY_ORIGINAL, b.isOpaque());
        b.setOpaque(false);
        b.setRolloverEnabled(true);
        LookAndFeel.installProperty(b, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(b)));
        if (Boolean.TRUE.equals(b.getClientProperty("substancelaf.internal.contentsModified"))) {
            this.trackModificationFlag();
        }
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty(BORDER_ORIGINAL));
        b.setOpaque((Boolean)b.getClientProperty(OPACITY_ORIGINAL));
        Icon origIcon = (Icon)b.getClientProperty(ICON_ORIGINAL);
        if (origIcon != null) {
            b.setIcon(origIcon);
        }
        b.putClientProperty(OPACITY_ORIGINAL, null);
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.substanceVisualStateTracker = new ButtonVisualStateTracker();
        this.substanceVisualStateTracker.installListeners(b, true);
        this.trackGlowingIcon();
        this.substancePropertyListener = evt -> {
            if ("icon".equals(evt.getPropertyName())) {
                this.trackGlowingIcon();
            }
            if ("substancelaf.internal.contentsModified".equals(evt.getPropertyName())) {
                boolean newValue = (Boolean)evt.getNewValue();
                if (newValue) {
                    this.trackModificationFlag();
                } else if (this.modifiedTimeline != null) {
                    this.modifiedTimeline.cancel();
                }
            }
            if ("model".equals(evt.getPropertyName())) {
                if (this.ghostModelChangeListener != null) {
                    this.ghostModelChangeListener.unregisterListeners();
                }
                this.ghostModelChangeListener = new GhostingListener(b, b.getModel());
                this.ghostModelChangeListener.registerListeners();
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        this.ghostModelChangeListener = new GhostingListener(b, b.getModel());
        this.ghostModelChangeListener.registerListeners();
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        this.substanceVisualStateTracker.uninstallListeners(b);
        this.substanceVisualStateTracker = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.ghostModelChangeListener.unregisterListeners();
        this.ghostModelChangeListener = null;
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
        super.uninstallListeners(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        AbstractButton b = (AbstractButton)c;
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        this.viewRect.x = i.left;
        this.viewRect.y = i.top;
        this.viewRect.width = b.getWidth() - (i.right + this.viewRect.x);
        this.viewRect.height = b.getHeight() - (i.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font f = c.getFont();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        View v = (View)c.getClientProperty("html");
        g2d.setFont(f);
        this.delegate.updateBackground(g2d, b);
        if (v != null) {
            v.paint(g2d, this.textRect);
        } else {
            this.paintButtonText(g2d, b, this.textRect, text);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g2d, c, this.iconRect);
        }
        if (b.isFocusPainted()) {
            SubstanceCoreUtilities.paintFocus(g2d, b, b, this, null, this.textRect, 1.0f, SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(b)));
        }
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        Dimension superPref = SubstanceMetricsUtilities.getPreferredButtonSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        return shaper.getPreferredSize(button, superPref);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JButton)c, x, y);
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        c.putClientProperty("icon.bounds", new Rectangle(iconRect));
        Graphics2D graphics = (Graphics2D)g.create();
        GhostPaintingUtils.paintGhostIcon(graphics, (AbstractButton)c, iconRect);
        AbstractButton b = (AbstractButton)c;
        Icon originalIcon = SubstanceCoreUtilities.getOriginalIcon(b, b.getIcon());
        Icon themedIcon = !(b instanceof JRadioButton) && !(b instanceof JCheckBox) && SubstanceCoreUtilities.useThemedDefaultIcon(b) ? SubstanceCoreUtilities.getThemedIcon(b, originalIcon) : originalIcon;
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)b, g));
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        float activeAmount = this.substanceVisualStateTracker.getStateTransitionTracker().getActiveStrength();
        graphics.translate(iconRect.x, iconRect.y);
        if (activeAmount >= 0.0f) {
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.ICON_GLOW, b) && this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker().isPlaying()) {
                this.glowingIcon.paintIcon(b, graphics, 0, 0);
            } else {
                themedIcon.paintIcon(b, graphics, 0, 0);
                graphics.setComposite(WidgetUtilities.getAlphaComposite(b, activeAmount, g));
                originalIcon.paintIcon(b, graphics, 0, 0);
            }
        } else {
            originalIcon.paintIcon(b, graphics, 0, 0);
        }
        graphics.dispose();
    }

    private void paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        SubstanceTextUtilities.paintText(g, button, textRect, text, button.getDisplayedMnemonicIndex());
    }

    private void trackGlowingIcon() {
        Icon currIcon = this.button.getIcon();
        if (currIcon instanceof GlowingIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(currIcon, this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return this.contains(this.button, me.getX(), me.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getStateTransitionTracker();
    }

    private void trackModificationFlag() {
        this.modifiedTimeline = ((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().modifiedTimelineBuilder(this.button).addCallback((TimelineCallback)new SwingRepaintCallback((Component)this.button))).build();
        this.modifiedTimeline.playLoop(Timeline.RepeatBehavior.REVERSE);
    }

    @Override
    public Timeline getModificationTimeline() {
        return this.modifiedTimeline;
    }
}

