/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.animation;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.UiThreadingViolationException;
import org.pushingpixels.substance.api.renderer.SubstanceRenderer;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.animation.IconGlowTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionEvent;
import org.pushingpixels.substance.internal.animation.StateTransitionListener;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.TimelineCallbackAdapter;
import org.pushingpixels.trident.swing.SwingComponentTimeline;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class StateTransitionTracker {
    private JComponent component;
    private ButtonModel model;
    private ChangeListener modelChangeListener;
    private Timeline transitionTimeline;
    private float transitionPosition;
    private FocusListener focusListener;
    private Timeline focusTimeline;
    private Timeline focusLoopTimeline;
    private IconGlowTracker iconGlowTracker;
    private RepaintCallback repaintCallback;
    private boolean isAutoTrackingModelChanges;
    private EventListenerList eventListenerList;
    private String name;
    private ModelStateInfo modelStateInfo;

    public StateTransitionTracker(JComponent component, ButtonModel model) {
        this.component = component;
        this.model = model;
        this.modelStateInfo = new ModelStateInfo();
        this.modelStateInfo.currState = ComponentState.getState(model, component);
        this.modelStateInfo.currStateNoSelection = ComponentState.getState(model, component, true);
        this.modelStateInfo.clear();
        this.repaintCallback = () -> new SwingRepaintCallback((Component)component);
        this.isAutoTrackingModelChanges = true;
        this.eventListenerList = new EventListenerList();
        this.focusTimeline = ((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().timelineBuilder(this.component).addCallback(this.repaintCallback.getRepaintCallback())).addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                SwingUtilities.invokeLater(() -> StateTransitionTracker.this.fireFocusStateTransitionEvent(oldState, newState));
            }
        })).build();
        this.focusLoopTimeline = ((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().timelineBuilder(this.component).addCallback(this.repaintCallback.getRepaintCallback())).build();
        this.iconGlowTracker = new IconGlowTracker(this.component);
        this.name = "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setRepaintCallback(RepaintCallback repaintCallback) {
        this.repaintCallback = repaintCallback;
    }

    public void registerFocusListeners() {
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                StateTransitionTracker.this.setFocusState(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                StateTransitionTracker.this.setFocusState(false);
            }
        };
        this.component.addFocusListener(this.focusListener);
    }

    public void registerModelListeners() {
        this.modelChangeListener = e -> {
            if (this.isAutoTrackingModelChanges) {
                this.onModelStateChanged();
            }
        };
        this.model.addChangeListener(this.modelChangeListener);
    }

    public void unregisterFocusListeners() {
        this.component.removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    public void unregisterModelListeners() {
        this.model.removeChangeListener(this.modelChangeListener);
        this.modelChangeListener = null;
    }

    public void setModel(ButtonModel model) {
        this.model.removeChangeListener(this.modelChangeListener);
        if (this.transitionTimeline != null) {
            this.transitionTimeline.abort();
            this.transitionPosition = 0.0f;
        }
        this.modelStateInfo.currState = ComponentState.getState(model, this.component);
        this.modelStateInfo.currStateNoSelection = ComponentState.getState(model, this.component, true);
        this.modelStateInfo.clear();
        this.model = model;
        this.model.addChangeListener(this.modelChangeListener);
        this.component.repaint();
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void turnOffModelChangeTracking() {
        this.isAutoTrackingModelChanges = false;
    }

    public void onModelStateChanged() {
        this.isAutoTrackingModelChanges = true;
        ComponentState newState = ComponentState.getState(this.model, this.component);
        ComponentState newStateNoSelection = ComponentState.getState(this.model, this.component, true);
        boolean isInRenderer = this.component.getClass().isAnnotationPresent(SubstanceRenderer.class);
        if (!isInRenderer) {
            for (Container parent = this.component.getParent(); parent != null; parent = parent.getParent()) {
                if (!CellRendererPane.class.isInstance(parent) && !ListCellRenderer.class.isInstance(parent) && !TreeCellRenderer.class.isInstance(parent) && !TableCellRenderer.class.isInstance(parent)) continue;
                isInRenderer = true;
                break;
            }
        }
        if (isInRenderer || this.component.getParent() == null) {
            this.modelStateInfo.currState = newState;
            this.modelStateInfo.currStateNoSelection = newStateNoSelection;
            this.modelStateInfo.clear();
            return;
        }
        if (this.modelStateInfo.currState == newState) {
            return;
        }
        if (this.transitionTimeline != null) {
            this.transitionTimeline.abort();
        }
        SwingComponentTimeline.Builder transitionTimelineBuilder = (SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().timelineBuilder(this.component).setForceUiUpdate(true).setName("Model transitions")).addCallback(this.repaintCallback.getRepaintCallback());
        if (!this.modelStateInfo.currState.isFacetActive(SubstanceSlices.ComponentStateFacet.SELECTION) && newState.isFacetActive(SubstanceSlices.ComponentStateFacet.SELECTION)) {
            transitionTimelineBuilder.setDuration(transitionTimelineBuilder.getDuration() / 2L);
        }
        long fullDuration = transitionTimelineBuilder.getDuration();
        if (this.modelStateInfo.stateContributionMap.containsKey(newState)) {
            this.transitionPosition = ((StateContributionInfo)this.modelStateInfo.stateContributionMap.get(newState)).getContribution();
            transitionTimelineBuilder.addPropertyToInterpolate(Timeline.property((String)"transitionPosition").getWith((obj, fieldName) -> Float.valueOf(this.transitionPosition)).setWith((obj, fieldName, value) -> {
                this.transitionPosition = value.floatValue();
            }).from((Object)Float.valueOf(this.transitionPosition)).to((Object)Float.valueOf(1.0f)));
            transitionTimelineBuilder.setDuration((long)((float)fullDuration * (1.0f - this.transitionPosition)));
        } else {
            this.transitionPosition = 0.0f;
            transitionTimelineBuilder.addPropertyToInterpolate(Timeline.property((String)"transitionPosition").getWith((obj, fieldName) -> Float.valueOf(this.transitionPosition)).setWith((obj, fieldName, value) -> {
                this.transitionPosition = value.floatValue();
            }).from((Object)Float.valueOf(0.0f)).to((Object)Float.valueOf(1.0f)));
        }
        HashMap<ComponentState, StateContributionInfo> newContributionMap = new HashMap<ComponentState, StateContributionInfo>();
        if (this.modelStateInfo.stateContributionMap.containsKey(newState)) {
            for (Map.Entry entry : this.modelStateInfo.stateContributionMap.entrySet()) {
                StateContributionInfo stateContributionInfo = (StateContributionInfo)entry.getValue();
                ComponentState componentState = (ComponentState)entry.getKey();
                float newEnd = componentState == newState ? 1.0f : 0.0f;
                newContributionMap.put(componentState, new StateContributionInfo(stateContributionInfo.curr, newEnd));
            }
        } else {
            for (Map.Entry entry : this.modelStateInfo.stateContributionMap.entrySet()) {
                StateContributionInfo stateContributionInfo = (StateContributionInfo)entry.getValue();
                ComponentState componentState = (ComponentState)entry.getKey();
                newContributionMap.put(componentState, new StateContributionInfo(stateContributionInfo.curr, 0.0f));
            }
            newContributionMap.put(newState, new StateContributionInfo(0.0f, 1.0f));
        }
        this.modelStateInfo.stateContributionMap = newContributionMap;
        HashMap<ComponentState, StateContributionInfo> newNoSelectionContributionMap = new HashMap<ComponentState, StateContributionInfo>();
        if (this.modelStateInfo.stateNoSelectionContributionMap.containsKey(newStateNoSelection)) {
            for (Map.Entry entry : this.modelStateInfo.stateNoSelectionContributionMap.entrySet()) {
                StateContributionInfo stateContributionInfo = (StateContributionInfo)entry.getValue();
                ComponentState state2 = (ComponentState)entry.getKey();
                float newEnd = state2 == newStateNoSelection ? 1.0f : 0.0f;
                newNoSelectionContributionMap.put(state2, new StateContributionInfo(stateContributionInfo.curr, newEnd));
            }
        } else {
            for (Map.Entry entry : this.modelStateInfo.stateNoSelectionContributionMap.entrySet()) {
                StateContributionInfo stateContributionInfo = (StateContributionInfo)entry.getValue();
                ComponentState state3 = (ComponentState)entry.getKey();
                newNoSelectionContributionMap.put(state3, new StateContributionInfo(stateContributionInfo.curr, 0.0f));
            }
            newNoSelectionContributionMap.put(newStateNoSelection, new StateContributionInfo(0.0f, 1.0f));
        }
        this.modelStateInfo.stateNoSelectionContributionMap = newNoSelectionContributionMap;
        this.modelStateInfo.sync();
        transitionTimelineBuilder.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (newState == Timeline.TimelineState.DONE) {
                    SwingUtilities.invokeLater(() -> {
                        StateTransitionTracker.this.modelStateInfo.clear();
                        StateTransitionTracker.this.repaintCallback.getRepaintCallback().onTimelineStateChanged(oldState, newState, durationFraction, timelinePosition);
                    });
                }
            }
        });
        transitionTimelineBuilder.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                SwingUtilities.invokeLater(() -> StateTransitionTracker.this.fireModelStateTransitionEvent(oldState, newState));
            }
        });
        transitionTimelineBuilder.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                SwingUtilities.invokeLater(() -> {
                    if (StateTransitionTracker.this.component instanceof JMenuItem) {
                        if (SubstanceCoreUtilities.isCoveredByLightweightPopups(StateTransitionTracker.this.component)) {
                            StateTransitionTracker.this.component.putClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups", Boolean.TRUE);
                        } else {
                            StateTransitionTracker.this.component.putClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups", null);
                        }
                    }
                });
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                SwingUtilities.invokeLater(() -> {
                    if (StateTransitionTracker.this.component instanceof JMenuItem) {
                        if (SubstanceCoreUtilities.isCoveredByLightweightPopups(StateTransitionTracker.this.component)) {
                            StateTransitionTracker.this.component.putClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups", Boolean.TRUE);
                        } else {
                            StateTransitionTracker.this.component.putClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups", null);
                        }
                    }
                });
            }
        });
        transitionTimelineBuilder.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                this.updateActiveStates(timelinePosition);
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                this.updateActiveStates(timelinePosition);
            }

            private void updateActiveStates(float timelinePosition) {
                SwingUtilities.invokeLater(() -> {
                    for (StateContributionInfo pair : StateTransitionTracker.this.modelStateInfo.stateContributionMap.values()) {
                        pair.updateContribution(timelinePosition);
                    }
                    for (StateContributionInfo pair : StateTransitionTracker.this.modelStateInfo.stateNoSelectionContributionMap.values()) {
                        pair.updateContribution(timelinePosition);
                    }
                    StateTransitionTracker.this.modelStateInfo.sync();
                });
            }
        });
        this.modelStateInfo.currState = newState;
        this.modelStateInfo.currStateNoSelection = newStateNoSelection;
        this.transitionTimeline = transitionTimelineBuilder.build();
        this.transitionTimeline.play();
        if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.ICON_GLOW, this.component)) {
            boolean bl;
            boolean bl2 = false;
            for (Map.Entry entry : this.modelStateInfo.stateContributionMap.entrySet()) {
                ComponentState activeState = (ComponentState)entry.getKey();
                if (activeState == this.modelStateInfo.currState || !activeState.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER)) continue;
                bl = true;
                break;
            }
            boolean bl3 = this.modelStateInfo.currState.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER);
            if (bl && !bl3) {
                this.iconGlowTracker.cancel();
            }
            if (!bl && bl3) {
                this.iconGlowTracker.play();
            }
        }
    }

    public float getFocusStrength(boolean hasFocus) {
        if (this.focusTimeline == null) {
            return 0.0f;
        }
        Timeline.TimelineState focusTimelineState = this.focusTimeline.getState();
        if (focusTimelineState == Timeline.TimelineState.READY || focusTimelineState == Timeline.TimelineState.PLAYING_FORWARD || focusTimelineState == Timeline.TimelineState.PLAYING_REVERSE) {
            return this.focusTimeline.getTimelinePosition();
        }
        return hasFocus ? 1.0f : 0.0f;
    }

    public float getFocusLoopPosition() {
        if (this.focusLoopTimeline == null) {
            return 0.0f;
        }
        return this.focusLoopTimeline.getTimelinePosition();
    }

    public float getIconGlowPosition() {
        return this.iconGlowTracker.getIconGlowPosition();
    }

    public float getFacetStrength(SubstanceSlices.ComponentStateFacet stateFacet) {
        float result = 0.0f;
        for (Map.Entry activeEntry : this.modelStateInfo.stateContributionMap.entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (!activeState.isFacetActive(stateFacet)) continue;
            result += ((StateContributionInfo)activeEntry.getValue()).getContribution();
        }
        return result;
    }

    public float getActiveStrength() {
        return this.modelStateInfo.getActiveStrength();
    }

    public void addStateTransitionListener(StateTransitionListener stateTransitionListener) {
        this.eventListenerList.add(StateTransitionListener.class, stateTransitionListener);
    }

    public void removeStateTransitionListener(StateTransitionListener stateTransitionListener) {
        this.eventListenerList.remove(StateTransitionListener.class, stateTransitionListener);
    }

    private void fireModelStateTransitionEvent(Timeline.TimelineState oldState, Timeline.TimelineState newState) {
        if (this.eventListenerList.getListenerCount() == 0) {
            return;
        }
        StateTransitionListener[] listeners = (StateTransitionListener[])this.eventListenerList.getListeners(StateTransitionListener.class);
        if (listeners == null || listeners.length == 0) {
            return;
        }
        StateTransitionEvent event = new StateTransitionEvent(this, oldState, newState);
        for (StateTransitionListener listener : listeners) {
            listener.onModelStateTransition(event);
        }
    }

    private void fireFocusStateTransitionEvent(Timeline.TimelineState oldState, Timeline.TimelineState newState) {
        if (this.eventListenerList.getListenerCount() == 0) {
            return;
        }
        StateTransitionListener[] listeners = (StateTransitionListener[])this.eventListenerList.getListeners(StateTransitionListener.class);
        if (listeners == null || listeners.length == 0) {
            return;
        }
        StateTransitionEvent event = new StateTransitionEvent(this, oldState, newState);
        for (StateTransitionListener listener : listeners) {
            listener.onFocusStateTransition(event);
        }
    }

    public void endTransition() {
        if (this.transitionTimeline != null) {
            this.transitionTimeline.end();
        }
    }

    public void setFocusState(boolean hasFocus) {
        if (hasFocus) {
            this.focusTimeline.play();
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.FOCUS_LOOP_ANIMATION, this.component)) {
                this.focusLoopTimeline.playLoop(Timeline.RepeatBehavior.LOOP);
            }
        } else {
            this.focusTimeline.playReverse();
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.FOCUS_LOOP_ANIMATION, this.component)) {
                this.focusLoopTimeline.cancel();
            }
        }
    }

    public boolean hasRunningTimelines() {
        Timeline.TimelineState modelTransitionTimelineState;
        Timeline.TimelineState focusLoopTimelineState;
        Timeline.TimelineState focusTimelineState;
        if (this.focusTimeline != null && (focusTimelineState = this.focusTimeline.getState()) != Timeline.TimelineState.IDLE) {
            return true;
        }
        if (this.focusLoopTimeline != null && (focusLoopTimelineState = this.focusLoopTimeline.getState()) != Timeline.TimelineState.IDLE) {
            return true;
        }
        if (this.iconGlowTracker.isPlaying()) {
            return true;
        }
        return this.transitionTimeline != null && (modelTransitionTimelineState = this.transitionTimeline.getState()) != Timeline.TimelineState.IDLE;
    }

    public IconGlowTracker getIconGlowTracker() {
        return this.iconGlowTracker;
    }

    public ModelStateInfo getModelStateInfo() {
        return this.modelStateInfo;
    }

    public static class ModelStateInfo {
        private Map<ComponentState, StateContributionInfo> stateContributionMap = new HashMap<ComponentState, StateContributionInfo>();
        private Map<ComponentState, StateContributionInfo> stateNoSelectionContributionMap = new HashMap<ComponentState, StateContributionInfo>();
        private ComponentState currState;
        private ComponentState currStateNoSelection;
        float activeStrength = 0.0f;

        public ComponentState getCurrModelState() {
            return this.currState;
        }

        public ComponentState getCurrModelStateNoSelection() {
            return this.currStateNoSelection;
        }

        public Map<ComponentState, StateContributionInfo> getStateContributionMap() {
            return this.stateContributionMap;
        }

        public Map<ComponentState, StateContributionInfo> getStateNoSelectionContributionMap() {
            return this.stateNoSelectionContributionMap;
        }

        void sync() {
            this.activeStrength = 0.0f;
            for (Map.Entry<ComponentState, StateContributionInfo> activeEntry : this.stateContributionMap.entrySet()) {
                ComponentState activeState = activeEntry.getKey();
                if (!activeState.isActive()) continue;
                this.activeStrength += activeEntry.getValue().getContribution();
            }
        }

        float getActiveStrength() {
            return this.activeStrength;
        }

        void clear() {
            if (!SwingUtilities.isEventDispatchThread()) {
                UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("State tracking must be done on Event Dispatch Thread");
                uiThreadingViolationError.printStackTrace(System.err);
                throw uiThreadingViolationError;
            }
            this.stateContributionMap.clear();
            this.stateContributionMap.put(this.currState, new StateContributionInfo(1.0f, 1.0f));
            this.stateNoSelectionContributionMap.clear();
            this.stateNoSelectionContributionMap.put(this.currStateNoSelection, new StateContributionInfo(1.0f, 1.0f));
            this.sync();
        }
    }

    public static class StateContributionInfo {
        float start;
        float end;
        float curr;

        public StateContributionInfo(float start, float end) {
            this.start = start;
            this.end = end;
            this.curr = start;
        }

        public float getContribution() {
            return this.curr;
        }

        void updateContribution(float timelinePosition) {
            this.curr = this.start + timelinePosition * (this.end - this.start);
        }
    }

    public static interface RepaintCallback {
        public TimelineCallback getRepaintCallback();
    }
}

