/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MarbleNoiseDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.MatteFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopShadowOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;

public class AutumnSkin
extends SubstanceSkin {
    public static final String NAME = "Autumn";

    public AutumnSkin() {
        SubstanceColorScheme enabledScheme;
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/autumn.colorschemes");
        SubstanceColorScheme activeScheme = schemes.get("Autumn Active");
        SubstanceColorScheme disabledScheme = enabledScheme = schemes.get("Autumn Enabled");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        defaultSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(disabledScheme, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(activeScheme, ComponentState.DISABLED_SELECTED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorSchemeBundle titlePaneSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        titlePaneSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        titlePaneSchemeBundle.registerColorScheme(disabledScheme, ComponentState.DISABLED_UNSELECTED);
        titlePaneSchemeBundle.registerColorScheme(activeScheme, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme borderScheme = enabledScheme.saturate(0.2f);
        titlePaneSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        this.registerDecorationAreaSchemeBundle(titlePaneSchemeBundle, activeScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
        SubstanceColorScheme watermarkScheme = schemes.get("Autumn Watermark");
        this.registerAsDecorationArea(activeScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        this.registerAsDecorationArea(watermarkScheme, SubstanceSlices.DecorationAreaType.GENERAL, SubstanceSlices.DecorationAreaType.FOOTER, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.addOverlayPainter(TopShadowOverlayPainter.getInstance(50), SubstanceSlices.DecorationAreaType.TOOLBAR);
        BottomLineOverlayPainter bottomLineOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.DARK);
        this.addOverlayPainter(bottomLineOverlayPainter, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new MatteFillPainter();
        this.borderPainter = new CompositeBorderPainter(NAME, new DelegateBorderPainter("Autumn Outer", new ClassicBorderPainter(), scheme -> scheme.shade(0.1f)), new DelegateBorderPainter("Autumn Inner", new ClassicBorderPainter(), scheme -> scheme.tint(0.8f)));
        this.highlightPainter = new ClassicHighlightPainter();
        MarbleNoiseDecorationPainter decorationPainter = new MarbleNoiseDecorationPainter();
        decorationPainter.setTextureAlpha(0.7f);
        this.decorationPainter = decorationPainter;
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

