/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.neon.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.event.EventListenerList;
import org.pushingpixels.neon.api.AsynchronousLoadListener;
import org.pushingpixels.neon.api.AsynchronousLoading;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public abstract class ResizableAsyncLoadingIcon
implements ResizableIcon,
AsynchronousLoading {
    protected ResizableIcon.Factory sourceFactory;
    protected int width;
    protected int height;
    protected ResizableIcon currDelegate;
    protected BufferedImage currColorized;
    protected EventListenerList listenerList;

    public ResizableAsyncLoadingIcon(ResizableIcon.Factory sourceFactory) {
        this.sourceFactory = sourceFactory;
        this.listenerList = new EventListenerList();
    }

    protected abstract void makeColorized();

    @Override
    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
        this.currDelegate = this.sourceFactory.createNewIcon();
        this.currDelegate.setDimension(newDimension);
        final AsynchronousLoading async = (AsynchronousLoading)((Object)this.currDelegate);
        if (async.isLoading()) {
            this.currColorized = null;
            async.addAsynchronousLoadListener(new AsynchronousLoadListener(){

                @Override
                public void completed(boolean success) {
                    if (success) {
                        ResizableAsyncLoadingIcon.this.makeColorized();
                    }
                    async.removeAsynchronousLoadListener(this);
                    Object[] listeners = ResizableAsyncLoadingIcon.this.listenerList.getListenerList();
                    for (int i = listeners.length - 2; i >= 0; i -= 2) {
                        if (listeners[i] != AsynchronousLoadListener.class) continue;
                        ((AsynchronousLoadListener)listeners[i + 1]).completed(success);
                    }
                }
            });
        } else {
            this.makeColorized();
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.currColorized != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            double scaleFactor = NeonCortex.getScaleFactor(c);
            NeonCortex.drawImageWithScale(g2d, scaleFactor, this.currColorized, 0, 0);
            g2d.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.add(AsynchronousLoadListener.class, l);
    }

    @Override
    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.remove(AsynchronousLoadListener.class, l);
    }

    @Override
    public boolean isLoading() {
        return this.currDelegate != null && ((AsynchronousLoading)((Object)this.currColorized)).isLoading();
    }
}

