/*
 * Decompiled with CFR 0.152.
 */
package org.purejava;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.SystemUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.keepassxc.Connection;
import org.keepassxc.LinuxMacConnection;
import org.keepassxc.WindowsConnection;
import org.purejava.Credentials;
import org.purejava.KeepassProxyAccessException;
import org.purejava.ValidLogin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepassProxyAccess
implements PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(KeepassProxyAccess.class);
    private Connection connection;
    private String fileLocation;
    private final String FILE_NAME = "keepass-proxy-access.dat";
    private final long SAVE_DELAY_MS = 1000L;
    private final AtomicReference<ScheduledFuture<?>> scheduledSaveCmd = new AtomicReference();
    private final ScheduledExecutorService scheduler;
    private final String V2_7_0 = "2.7.0";

    public KeepassProxyAccess() {
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            this.connection = new LinuxMacConnection();
            this.fileLocation = System.getProperty("user.home");
            if (SystemUtils.IS_OS_LINUX) {
                this.fileLocation = this.fileLocation + "/.config/keepass-proxy-access/keepass-proxy-access.dat";
            }
            if (SystemUtils.IS_OS_MAC_OSX) {
                this.fileLocation = this.fileLocation + "/Library/Application Support/keepass-proxy-access/keepass-proxy-access.dat";
            }
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            this.connection = new WindowsConnection();
            this.fileLocation = System.getenv("AppData") + "/keepass-proxy-access/keepass-proxy-access.dat";
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.connection.addPropertyChangeListener(this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.connection.removePropertyChangeListener(this);
            try {
                this.shutdown();
            }
            catch (Exception e) {
                LOG.error(e.toString(), e.getCause());
            }
        }));
        this.connection.setCredentials(this.loadCredentials());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<Credentials> loadCredentials() {
        try (FileInputStream fileIs = new FileInputStream(this.fileLocation);){
            Optional<Credentials> optional;
            try (ObjectInputStream objIs = new ObjectInputStream(fileIs);){
                Credentials c = (Credentials)objIs.readObject();
                optional = Optional.of(c);
            }
            return optional;
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.debug("Credentials could not be read from disc");
            return Optional.empty();
        }
    }

    private void scheduleSave(Optional<Credentials> credentials) {
        if (credentials.isEmpty()) {
            LOG.debug("Credentials are not present and won't be saved");
            return;
        }
        Runnable saveCommand = () -> this.saveCredentials(credentials);
        ScheduledFuture<?> scheduledTask = this.scheduler.schedule(saveCommand, 1000L, TimeUnit.MILLISECONDS);
        ScheduledFuture<?> previouslyScheduledTask = this.scheduledSaveCmd.getAndSet(scheduledTask);
        if (previouslyScheduledTask != null) {
            previouslyScheduledTask.cancel(false);
        }
    }

    private void saveCredentials(Optional<Credentials> credentials) {
        LOG.debug("Attempting to save credentials");
        try {
            Path path = Path.of(this.fileLocation, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Path tmpPath = path.resolveSibling(path.getFileName().toString() + ".tmp");
            try (OutputStream ops = Files.newOutputStream(tmpPath, StandardOpenOption.CREATE_NEW);
                 ObjectOutputStream objOps = new ObjectOutputStream(ops);){
                objOps.writeObject(credentials.get());
                objOps.flush();
            }
            Files.move(tmpPath, path, StandardCopyOption.REPLACE_EXISTING);
            LOG.debug("Credentials saved");
        }
        catch (IOException e) {
            LOG.error("Credentials could not be saved to disc");
            LOG.error(e.toString(), e.getCause());
        }
    }

    public Map<String, String> exportConnection() {
        return Map.of("id", this.connection.getAssociateId(), "key", this.connection.getIdKeyPairPublicKey());
    }

    public boolean connect() {
        try {
            this.connection.connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean associate() {
        try {
            this.connection.associate();
            return true;
        }
        catch (IOException | IllegalStateException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return false;
        }
    }

    public boolean connectionAvailable() {
        return this.getIdKeyPairPublicKey() != null && !this.getIdKeyPairPublicKey().isEmpty() && this.getAssociateId() != null && !this.getAssociateId().isEmpty() && this.testAssociate(this.getAssociateId(), this.getIdKeyPairPublicKey());
    }

    public boolean testAssociate(String id, String key) {
        try {
            this.connection.testAssociate(id, key);
            return true;
        }
        catch (IOException | IllegalStateException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return false;
        }
    }

    public Optional<String> getDatabasehash(boolean ... unlock) {
        try {
            if (unlock.length > 1) {
                throw new IllegalStateException("Invalid number of parameters for getDatabasehash(boolean... unlock)");
            }
            return switch (unlock.length) {
                case 0 -> Optional.of(this.connection.getDatabasehash());
                case 1 -> Optional.of(this.connection.getDatabasehash(unlock[0]));
                default -> Optional.empty();
            };
        }
        catch (IOException | IllegalStateException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return Optional.empty();
        }
    }

    public boolean isDatabaseLocked() {
        return this.getDatabasehash(new boolean[0]).isEmpty();
    }

    public Map<String, Object> getLogins(String url, String submitUrl, boolean httpAuth, List<Map<String, String>> list) {
        try {
            return this.connection.getLogins(url, submitUrl, httpAuth, list).toMap();
        }
        catch (IOException | IllegalStateException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return Map.of();
        }
    }

    public ValidLogin loginExists(String url, String submitUrl, boolean httpAuth, List<Map<String, String>> list, String password) {
        Map<String, Object> response = this.getLogins(url, submitUrl, httpAuth, list);
        if (response.isEmpty()) {
            return new ValidLogin(false, null);
        }
        ArrayList array = (ArrayList)response.get("entries");
        for (Object o : array) {
            HashMap credentials = (HashMap)o;
            if (!credentials.get("password").equals(password)) continue;
            return new ValidLogin(true, credentials.get("uuid").toString());
        }
        return new ValidLogin(true, null);
    }

    public boolean setLogin(String url, String submitUrl, String id, String login, String password, String group, String groupUuid, String uuid) {
        try {
            JSONObject response = this.connection.setLogin(url, submitUrl, id, login, password, group, groupUuid, uuid);
            return response.has("success") && response.getString("success").equals("true");
        }
        catch (IOException | IllegalStateException | JSONException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return false;
        }
    }

    public JSONObject getDatabaseGroups() {
        try {
            return this.connection.getDatabaseGroups();
        }
        catch (IOException | IllegalStateException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return new JSONObject();
        }
    }

    public String generatePassword() {
        try {
            JSONObject response = this.connection.generatePassword();
            if (this.isMinimiumVersion(response.getString("version"), "2.7.0")) {
                return response.getString("password");
            }
            return response.getJSONArray("entries").getJSONObject(0).getString("password");
        }
        catch (IOException | IllegalStateException | JSONException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return "";
        }
    }

    public boolean lockDatabase() {
        try {
            this.connection.lockDatabase();
            return true;
        }
        catch (IOException | IllegalStateException | JSONException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return false;
        }
    }

    public Map<String, String> createNewGroup(String path) {
        try {
            return this.getNewGroupId(this.connection.createNewGroup(path));
        }
        catch (IOException | IllegalStateException | JSONException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return Map.of();
        }
    }

    public String getTotp(String uuid) {
        try {
            return this.connection.getTotp(uuid).getString("totp");
        }
        catch (IOException | IllegalStateException | JSONException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return "";
        }
    }

    public boolean deleteEntry(String uuid) {
        try {
            JSONObject response = this.connection.deleteEntry(uuid);
            return response.has("success") && response.getString("success").equals("true");
        }
        catch (IOException | IllegalStateException | JSONException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return false;
        }
    }

    public boolean requestAutotype(String url) {
        try {
            JSONObject response = this.connection.requestAutotype(url);
            return response.has("success") && response.getString("success").equals("true");
        }
        catch (IOException | IllegalStateException | JSONException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return false;
        }
    }

    public JSONObject passkeysRegister(JSONObject publicKey, String origin, List<Map<String, String>> list) {
        try {
            JSONObject response = this.connection.passkeysRegister(publicKey, origin, list);
            return this.parsePasskeysResponse(response);
        }
        catch (IOException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return new JSONObject();
        }
    }

    public JSONObject passkeysGet(JSONObject publicKey, String origin, List<Map<String, String>> list) {
        try {
            JSONObject response = this.connection.passkeysGet(publicKey, origin, list);
            return this.parsePasskeysResponse(response);
        }
        catch (IOException | KeepassProxyAccessException e) {
            LOG.info(e.toString(), e.getCause());
            return new JSONObject();
        }
    }

    private JSONObject parsePasskeysResponse(JSONObject response) throws KeepassProxyAccessException {
        if (response.has("response") && response.has("success") && response.getString("success").equals("true")) {
            try {
                int errorCode = response.getJSONObject("response").getInt("errorCode");
                throw new KeepassProxyAccessException("ErrorCode: " + errorCode);
            }
            catch (JSONException e) {
                return response.getJSONObject("response");
            }
        }
        return new JSONObject();
    }

    public Map<String, String> getNewGroupId(JSONObject jo) {
        return Map.of("name", jo.getString("name"), "uuid", jo.getString("uuid"));
    }

    public Map<String, String> databaseGroupsToMap(JSONObject groups) {
        if (groups.isEmpty()) {
            return Map.of();
        }
        HashMap<String, String> groupTree = new HashMap<String, String>();
        Map m = groups.toMap();
        HashMap n = (HashMap)m.get("groups");
        ArrayList rootGroups = (ArrayList)n.get("groups");
        HashMap rootGroup = (HashMap)rootGroups.get(0);
        ArrayList children = (ArrayList)rootGroup.get("children");
        this.traverse(children, groupTree);
        return groupTree;
    }

    private void traverse(List<Object> children, Map<String, String> groups) {
        children.stream().map(listItem -> (HashMap)listItem).forEach(li -> {
            ArrayList alc = (ArrayList)li.get("children");
            if (alc.size() == 0) {
                groups.put(li.get("name").toString(), li.get("uuid").toString());
            } else {
                groups.put(li.get("name").toString(), li.get("uuid").toString());
                this.traverse(alc, groups);
            }
        });
    }

    private boolean isMinimiumVersion(String v1, String v2) {
        return ModuleDescriptor.Version.parse(v1).compareTo(ModuleDescriptor.Version.parse(v2)) >= 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.scheduleSave((Optional)event.getNewValue());
    }

    public String getIdKeyPairPublicKey() {
        return this.connection.getIdKeyPairPublicKey();
    }

    public String getAssociateId() {
        return this.connection.getAssociateId();
    }

    public boolean shutdown() {
        try {
            this.connection.close();
            return true;
        }
        catch (Exception e) {
            LOG.error(e.toString(), e.getCause());
            return false;
        }
    }

    public boolean closeConnection() {
        try {
            this.connection.terminateConnection();
            return true;
        }
        catch (IOException e) {
            LOG.error(e.toString(), e.getCause());
            return false;
        }
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }
}

