/*
 * Decompiled with CFR 0.152.
 */
package org.keepassxc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutionException;
import org.json.JSONException;
import org.json.JSONObject;
import org.keepassxc.Connection;
import org.purejava.KeepassProxyAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsConnection
extends Connection {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsConnection.class);
    private final int BUFFER_SIZE = 8192;
    private AsynchronousFileChannel pipe;
    private final ByteBuffer buffer = ByteBuffer.allocate(8192);
    private final Charset charset = StandardCharsets.UTF_8;
    private final CharsetDecoder charsetDecoder = this.charset.newDecoder();
    private final CharBuffer charBuffer = CharBuffer.allocate(8192);

    @Override
    public void connect() throws IOException {
        try {
            Path path = Paths.get("\\\\.\\pipe\\org.keepassxc.KeePassXC.BrowserServer_" + System.getenv("USERNAME"), new String[0]);
            this.pipe = AsynchronousFileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            LOG.error("Cannot connect to proxy. Is KeepassXC started?");
            throw e;
        }
        try {
            this.lauchMessagePublisher();
            this.changePublicKeys();
        }
        catch (KeepassProxyAccessException e) {
            LOG.error(e.toString(), e.getCause());
        }
    }

    @Override
    protected void sendCleartextMessage(String msg) throws IOException {
        if (!this.pipe.isOpen()) {
            throw new IOException("Pipe closed");
        }
        LOG.trace("Sending message: {}", (Object)msg);
        this.pipe.write(ByteBuffer.wrap(msg.getBytes(StandardCharsets.UTF_8)), 0L);
    }

    @Override
    protected JSONObject getCleartextResponse() {
        StringBuilder raw = new StringBuilder();
        long position = 0L;
        try {
            this.pipe.read(this.buffer, position).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error(e.toString(), e.getCause());
        }
        this.buffer.flip();
        this.charsetDecoder.decode(this.buffer, this.charBuffer, true);
        this.charBuffer.flip();
        raw.append(this.charBuffer);
        this.buffer.compact();
        this.charBuffer.clear();
        LOG.trace("Reading message: {}", (Object)raw);
        try {
            String s = raw.toString();
            if (s.length() - s.replace("}", "").length() > 1) {
                throw new JSONException("");
            }
            return new JSONObject(raw.toString());
        }
        catch (JSONException e) {
            LOG.error("Message corrupted. Received: {}", (Object)raw);
            return new JSONObject();
        }
    }

    @Override
    protected boolean isConnected() {
        return null != this.pipe && this.pipe.isOpen();
    }

    @Override
    public void terminateConnection() throws IOException {
        if (this.isConnected()) {
            this.pipe.close();
        }
    }

    @Override
    public void close() throws Exception {
        if (null != this.messagePublisher) {
            this.messagePublisher.doStop();
        }
        this.executorService.shutdown();
        if (this.isConnected()) {
            this.pipe.close();
        }
    }
}

