/*
 * Decompiled with CFR 0.152.
 */
package org.keepassxc;

import java.io.File;
import java.io.IOException;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.SystemUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.keepassxc.Connection;
import org.keepassxc.KeePassXCType;
import org.keepassxc.KindOfKeePassXC;
import org.purejava.KeepassProxyAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxMacConnection
extends Connection {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxMacConnection.class);
    private final int BUFFER_SIZE = 1024;
    private SocketChannel socket;
    private final UnixDomainSocketAddress socketAddress;
    private final ByteBuffer buffer = ByteBuffer.allocate(1024);
    private final Charset charset = StandardCharsets.UTF_8;
    private final CharsetDecoder charsetDecoder = this.charset.newDecoder();
    private final CharBuffer charBuffer = CharBuffer.allocate(1024);
    private static final String FLATPAK_PATH = "/app/org.keepassxc.KeePassXC";
    private static final String SNAP_PATH = System.getProperty("user.home") + "/snap/keepassxc/common";

    public LinuxMacConnection() {
        String socketPath = this.getSocketPath();
        this.socketAddress = UnixDomainSocketAddress.of(socketPath + "/org.keepassxc.KeePassXC.BrowserServer");
    }

    @Override
    public void connect() throws IOException {
        try {
            this.socket = SocketChannel.open(this.socketAddress);
        }
        catch (IOException e) {
            LOG.error("Cannot connect to proxy. Is KeepassXC started?");
            throw e;
        }
        try {
            this.lauchMessagePublisher();
            this.changePublicKeys();
        }
        catch (KeepassProxyAccessException e) {
            LOG.error(e.toString(), e.getCause());
        }
    }

    @Override
    protected void sendCleartextMessage(String msg) throws IOException {
        if (!this.socket.isOpen()) {
            throw new IOException("Socket closed");
        }
        LOG.trace("Sending message: {}", (Object)msg);
        this.socket.write(ByteBuffer.wrap(msg.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    protected JSONObject getCleartextResponse() {
        StringBuilder raw = new StringBuilder();
        while (true) {
            try {
                if (this.socket.read(this.buffer) == -1) {
                    break;
                }
            }
            catch (IOException e) {
                LOG.error(e.toString(), e.getCause());
                return new JSONObject();
            }
            this.buffer.flip();
            this.charsetDecoder.decode(this.buffer, this.charBuffer, true);
            this.charBuffer.flip();
            raw.append(this.charBuffer);
            this.buffer.compact();
            if (this.charBuffer.toString().contains("}")) {
                this.charBuffer.clear();
                break;
            }
            this.charBuffer.clear();
        }
        LOG.trace("Reading message: {}", (Object)raw);
        try {
            String s = raw.toString();
            if (s.length() - s.replace("}", "").length() > 1) {
                throw new JSONException("");
            }
            return new JSONObject(raw.toString());
        }
        catch (JSONException e) {
            LOG.error("Message corrupted. Received: {}", (Object)raw);
            return new JSONObject();
        }
    }

    private String getSocketPath() {
        if (SystemUtils.IS_OS_LINUX) {
            Optional<KeePassXCType> type = KindOfKeePassXC.determineType();
            if (type.isEmpty()) {
                return this.getXDGPath();
            }
            switch (type.get()) {
                case Repo: 
                case AppImage: {
                    return this.getXDGPath();
                }
                case Flatpak: {
                    LOG.debug("Using XDG_RUNTIME_DIR/app/org.keepassxc.KeePassXC");
                    return System.getenv("XDG_RUNTIME_DIR") + FLATPAK_PATH;
                }
                case Snap: {
                    LOG.debug("Using " + SNAP_PATH);
                    return SNAP_PATH;
                }
            }
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            return System.getenv("TMPDIR");
        }
        return "-";
    }

    private String getXDGPath() {
        String path = System.getenv("XDG_RUNTIME_DIR");
        LOG.debug("Checking if XDG_RUNTIME_DIR exists ...");
        if (null == path) {
            LOG.debug("Unable to find XDG_RUNTIME_DIR");
            path = System.getenv("TMPDIR");
            LOG.debug("Using TEMPDIR");
            return null == path ? "/tmp" : path;
        }
        File flatpakPath = new File(path + FLATPAK_PATH);
        if (flatpakPath.exists()) {
            LOG.debug("Using XDG_RUNTIME_DIR/app/org.keepassxc.KeePassXC");
            return path + FLATPAK_PATH;
        }
        LOG.debug("Using XDG_RUNTIME_DIR");
        return path;
    }

    @Override
    protected boolean isConnected() {
        return null != this.socket && this.socket.isOpen();
    }

    @Override
    public void terminateConnection() throws IOException {
        if (this.isConnected()) {
            this.socket.close();
        }
    }

    @Override
    public void close() throws Exception {
        if (null != this.messagePublisher) {
            this.messagePublisher.doStop();
        }
        this.executorService.shutdown();
        if (this.isConnected()) {
            this.socket.close();
        }
    }
}

