/*
 * Decompiled with CFR 0.152.
 */
package org.keepassxc;

import java.util.Optional;
import org.apache.commons.lang3.SystemUtils;
import org.keepassxc.KeePassXCType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KindOfKeePassXC {
    private static final Logger LOG = LoggerFactory.getLogger(KindOfKeePassXC.class);

    public static Optional<KeePassXCType> determineType() {
        if (!SystemUtils.IS_OS_LINUX) {
            return Optional.empty();
        }
        Optional<ProcessHandle> processHandle = ProcessHandle.allProcesses().filter(ph -> ph.info().command().isPresent() && ph.info().command().get().contains("KeePassXC") && ph.info().command().get().contains("AppImage")).findFirst();
        if (processHandle.isPresent()) {
            LOG.debug("Found running KeePassXC AppImage");
            return Optional.of(KeePassXCType.AppImage);
        }
        processHandle = ProcessHandle.allProcesses().filter(ph -> ph.info().commandLine().isPresent() && ph.info().commandLine().get().contains("keepassxc") && ph.info().commandLine().get().contains("bwrap")).findFirst();
        if (processHandle.isPresent()) {
            LOG.debug("Found running KeePassXC installed via Flatpak");
            return Optional.of(KeePassXCType.Flatpak);
        }
        processHandle = ProcessHandle.allProcesses().filter(ph -> ph.info().commandLine().isPresent() && ph.info().commandLine().get().contains("keepassxc") && ph.info().commandLine().get().contains("snap")).findFirst();
        if (processHandle.isPresent()) {
            LOG.debug("Found running KeePassXC installed via Snap");
            return Optional.of(KeePassXCType.Snap);
        }
        processHandle = ProcessHandle.allProcesses().filter(ph -> ph.info().commandLine().isPresent() && ph.info().commandLine().get().contains("keepassxc")).findFirst();
        if (processHandle.isPresent()) {
            LOG.debug("Found running KeePassXC installed from repository");
            return Optional.of(KeePassXCType.Repo);
        }
        LOG.debug("Could not find running KeePassXC application");
        return Optional.empty();
    }
}

