/*
 * Decompiled with CFR 0.152.
 */
package org.keepassxc;

import com.iwebpp.crypto.TweetNaclFast;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.purejava.Credentials;
import org.purejava.KeepassProxyAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Connection
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Connection.class);
    private final PropertyChangeSupport support;
    private TweetNaclFast.Box box;
    private Optional<Credentials> credentials;
    private final String clientID;
    private static final int nonceLength = 24;
    private byte[] nonce;
    final ExecutorService executorService = Executors.newFixedThreadPool(12);
    protected MessagePublisher messagePublisher;
    private final long QUEUE_CHECKING_INTERVAL_MS = 100L;
    private final long SLOW_QUEUE_PROCESSING_MS = 500L;
    private final ConcurrentLinkedQueue<JSONObject> queue = new ConcurrentLinkedQueue();
    private final int MAX_ERROR_COUNT = 4;
    private final int RECONNECT_DELAY_S = 15;
    private final AtomicReference<ScheduledFuture<?>> scheduledConnectCmd = new AtomicReference();
    private final long RESPONSE_DELAY_MS = 500L;
    private final ScheduledExecutorService scheduler;
    private final int RESPONSE_TIMEOUT_S = 5;
    protected final String PROXY_NAME = "org.keepassxc.KeePassXC.BrowserServer";
    private static final String NOT_CONNECTED = "Not connected to KeePassXC. Call connect().";
    private static final String KEYEXCHANGE_MISSING = "Public keys need to be exchanged. Call changePublicKeys().";
    private static final String MISSING_CLASS = "Credentials have not been initialized";
    public static final String EXCEPTION_INFO = "Delaying association dialog response lookup due to https://github.com/keepassxreboot/keepassxc/issues/7099";
    private static final Set<String> REQUESTS_WITHOUT_MANUAL_USER_INPUT = Set.of(Message.CHANGE_PUBLIC_KEYS.action, Message.GET_DATABASE_HASH.action, Message.TEST_ASSOCIATE.action, Message.GET_DATABASE_GROUPS.action);

    public Connection() {
        byte[] array = new byte[24];
        new Random().nextBytes(array);
        this.clientID = this.b64encode(array);
        this.nonce = TweetNaclFast.randombytes((int)24);
        this.credentials = Optional.empty();
        this.support = new PropertyChangeSupport(this);
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    void lauchMessagePublisher() {
        this.messagePublisher = new MessagePublisher();
        LOG.debug("MessagePublisher started");
        this.executorService.execute(this.messagePublisher);
    }

    private void reconnect() {
        Runnable connect = () -> {
            try {
                this.connect();
            }
            catch (IOException e) {
                this.reconnect();
            }
        };
        ScheduledFuture<?> scheduledTask = this.scheduler.schedule(connect, 15L, TimeUnit.SECONDS);
        ScheduledFuture<?> previouslyScheduledTask = this.scheduledConnectCmd.getAndSet(scheduledTask);
        if (previouslyScheduledTask != null) {
            previouslyScheduledTask.cancel(false);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public abstract void connect() throws IOException;

    protected abstract void sendCleartextMessage(String var1) throws IOException;

    protected abstract JSONObject getCleartextResponse();

    private boolean isSignal(JSONObject response) {
        try {
            return response.has("action") && response.getString("action").equals(Message.DATABASE_LOCKED.action) || response.has("action") && response.getString("action").equals(Message.DATABASE_UNLOCKED.action);
        }
        catch (JSONException je) {
            return false;
        }
    }

    private synchronized byte[] sendEncryptedMessage(Map<String, Object> msg) throws IOException {
        boolean unlockRequested = false;
        if (!this.isConnected()) {
            throw new IllegalStateException(NOT_CONNECTED);
        }
        byte[] publicKey = this.credentials.orElseThrow(() -> new IllegalStateException(KEYEXCHANGE_MISSING)).getServerPublicKey();
        TweetNaclFast.Box.KeyPair keyPair = this.credentials.orElseThrow(() -> new IllegalStateException(KEYEXCHANGE_MISSING)).getOwnKeypair();
        if (msg.containsKey("triggerUnlock") && msg.get("triggerUnlock").equals("true")) {
            msg.remove("triggerUnlock");
            unlockRequested = true;
        }
        String strMsg = this.jsonTxt(msg);
        LOG.trace("Send - encrypting the following message: {}", (Object)strMsg);
        this.box = new TweetNaclFast.Box(publicKey, keyPair.getSecretKey());
        this.nonce = this.ramdomGenerateNonce();
        String encrypted = this.b64encode(this.box.box(strMsg.getBytes(), this.nonce));
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("action", msg.get("action").toString());
        message.put("message", encrypted);
        message.put("nonce", this.b64encode(this.nonce));
        message.put("clientID", this.clientID);
        if (unlockRequested) {
            message.put("triggerUnlock", "true");
        }
        this.sendCleartextMessage(this.jsonTxt(message));
        return this.nonce;
    }

    private synchronized JSONObject getEncryptedResponseAndDecrypt(String action, byte[] nonce) throws KeepassProxyAccessException {
        JSONObject response = new JSONObject();
        try {
            response = REQUESTS_WITHOUT_MANUAL_USER_INPUT.contains(action) ? this.executorService.submit(new MessageConsumer(action, nonce)).get(5L, TimeUnit.SECONDS) : this.executorService.submit(new MessageConsumer(action, nonce)).get();
        }
        catch (TimeoutException toe) {
            throw new KeepassProxyAccessException("Timeout for action '" + action + "'");
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error(e.toString(), e.getCause());
        }
        if (response.has("error")) {
            throw new KeepassProxyAccessException("ErrorCode: " + response.getString("errorCode") + ", " + response.getString("error"));
        }
        byte[] serverNonce = this.b64decode(response.getString("nonce").getBytes());
        byte[] bMessage = this.box.open(this.b64decode(response.getString("message").getBytes()), serverNonce);
        if (bMessage == null) {
            throw new KeepassProxyAccessException("Error: message could not be decrypted");
        }
        String decrypted = new String(bMessage, StandardCharsets.UTF_8);
        LOG.trace("Decrypted message: {}", (Object)decrypted);
        JSONObject decryptedResponse = new JSONObject(decrypted);
        if (!decryptedResponse.has("success")) {
            throw new KeepassProxyAccessException("ErrorCode: " + response.getString("errorCode") + ", " + response.getString("error"));
        }
        return decryptedResponse;
    }

    protected void changePublicKeys() throws IOException, KeepassProxyAccessException {
        if (!this.isConnected()) {
            throw new IllegalStateException(NOT_CONNECTED);
        }
        TweetNaclFast.Box.KeyPair keyPair = TweetNaclFast.Box.keyPair();
        this.nonce = this.ramdomGenerateNonce();
        this.sendCleartextMessage(this.jsonTxt(Map.of("action", Message.CHANGE_PUBLIC_KEYS.action, "publicKey", this.b64encode(keyPair.getPublicKey()), "nonce", this.b64encode(this.nonce), "clientID", this.clientID)));
        JSONObject response = new JSONObject();
        try {
            response = this.executorService.submit(new MessageConsumer(Message.CHANGE_PUBLIC_KEYS.action, this.nonce)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error(e.toString(), e.getCause());
        }
        if (!response.has("success")) {
            throw new KeepassProxyAccessException("ErrorCode: " + response.getString("errorCode") + ", " + response.getString("error"));
        }
        byte[] publicKey = this.b64decode(response.getString("publicKey").getBytes());
        this.box = new TweetNaclFast.Box(publicKey, keyPair.getSecretKey());
        if (this.credentials.isEmpty()) {
            this.setCredentials(Optional.of(new Credentials()));
        }
        this.credentials.orElseThrow(() -> new IllegalStateException(MISSING_CLASS)).setOwnKeypair(keyPair);
        this.credentials.orElseThrow(() -> new IllegalStateException(MISSING_CLASS)).setServerPublicKey(publicKey);
        this.support.firePropertyChange("credentialsCreated", null, this.credentials);
    }

    public void associate() throws IOException, KeepassProxyAccessException {
        TweetNaclFast.Box.KeyPair idKeyPair = TweetNaclFast.Box.keyPair();
        TweetNaclFast.Box.KeyPair keyPair = this.credentials.orElseThrow(() -> new IllegalStateException(KEYEXCHANGE_MISSING)).getOwnKeypair();
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.ASSOCIATE.action, "key", this.b64encode(keyPair.getPublicKey()), "idKey", this.b64encode(idKeyPair.getPublicKey())));
        Runnable lookupResponse = () -> {
            JSONObject response = null;
            try {
                response = this.getEncryptedResponseAndDecrypt(Message.ASSOCIATE.action, nonce);
            }
            catch (KeepassProxyAccessException e) {
                LOG.error(e.toString(), e.getCause());
            }
            assert (response != null);
            this.credentials.orElseThrow(() -> new IllegalStateException(MISSING_CLASS)).setAssociateId(response.getString("id"));
            this.credentials.orElseThrow(() -> new IllegalStateException(MISSING_CLASS)).setIdKeyPublicKey(idKeyPair.getPublicKey());
            this.support.firePropertyChange("associated", null, this.credentials);
        };
        this.scheduler.schedule(lookupResponse, 500L, TimeUnit.MILLISECONDS);
        throw new KeepassProxyAccessException(EXCEPTION_INFO);
    }

    public String getDatabasehash() throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.GET_DATABASE_HASH.action));
        JSONObject response = this.getEncryptedResponseAndDecrypt(Message.GET_DATABASE_HASH.action, nonce);
        return response.getString("hash");
    }

    public String getDatabasehash(boolean triggerUnlock) throws IOException, KeepassProxyAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", Message.GET_DATABASE_HASH.action);
        map.put("triggerUnlock", Boolean.toString(triggerUnlock));
        byte[] nonce = this.sendEncryptedMessage(map);
        JSONObject response = this.getEncryptedResponseAndDecrypt(Message.GET_DATABASE_HASH.action, nonce);
        return response.getString("hash");
    }

    public void testAssociate(String id, String key) throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.TEST_ASSOCIATE.action, "id", id, "key", key));
        this.getEncryptedResponseAndDecrypt(Message.TEST_ASSOCIATE.action, nonce);
    }

    public JSONObject getLogins(String url, String submitUrl, boolean httpAuth, List<Map<String, String>> list) throws IOException, KeepassProxyAccessException {
        JSONArray jsonArray = this.checkKeysList(list);
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.GET_LOGINS.action, "url", this.ensureNotNull(url), "submitUrl", this.ensureNotNull(submitUrl), "httpAuth", httpAuth, "keys", jsonArray));
        return this.getEncryptedResponseAndDecrypt(Message.GET_LOGINS.action, nonce);
    }

    public JSONObject setLogin(String url, String submitUrl, String id, String login, String password, String group, String groupUuid, String uuid) throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.SET_LOGIN.action, "url", this.ensureNotNull(url), "submitUrl", this.ensureNotNull(submitUrl), "id", this.ensureNotNull(id), "login", this.ensureNotNull(login), "password", this.ensureNotNull(password), "group", this.ensureNotNull(group), "groupUuid", this.ensureNotNull(groupUuid), "uuid", this.ensureNotNull(uuid)));
        return this.getEncryptedResponseAndDecrypt(Message.SET_LOGIN.action, nonce);
    }

    public JSONObject getDatabaseGroups() throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.GET_DATABASE_GROUPS.action));
        return this.getEncryptedResponseAndDecrypt(Message.GET_DATABASE_GROUPS.action, nonce);
    }

    public JSONObject generatePassword() throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.GENERATE_PASSWORD.action, "clientID", this.clientID));
        return this.getEncryptedResponseAndDecrypt(Message.GENERATE_PASSWORD.action, nonce);
    }

    public JSONObject lockDatabase() throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.LOCK_DATABASE.action));
        return this.getEncryptedResponseAndDecrypt(Message.LOCK_DATABASE.action, nonce);
    }

    public JSONObject createNewGroup(String path) throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.CREATE_NEW_GROUP.action, "groupName", this.ensureNotNull(path)));
        return this.getEncryptedResponseAndDecrypt(Message.CREATE_NEW_GROUP.action, nonce);
    }

    public JSONObject getTotp(String uuid) throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.GET_TOTP.action, "uuid", this.ensureNotNull(uuid)));
        return this.getEncryptedResponseAndDecrypt(Message.GET_TOTP.action, nonce);
    }

    public JSONObject deleteEntry(String uuid) throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.DELETE_ENTRY.action, "uuid", this.ensureNotNull(uuid)));
        return this.getEncryptedResponseAndDecrypt(Message.DELETE_ENTRY.action, nonce);
    }

    public JSONObject requestAutotype(String url) throws IOException, KeepassProxyAccessException {
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.REQUEST_AUTOTYPE.action, "groupName", this.ensureNotNull(url)));
        return this.getEncryptedResponseAndDecrypt(Message.REQUEST_AUTOTYPE.action, nonce);
    }

    public JSONObject passkeysRegister(JSONObject publicKey, String origin, List<Map<String, String>> list) throws IOException, KeepassProxyAccessException {
        JSONArray jsonArray = this.checkKeysList(list);
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.PASSKEYS_REGISTER.action, "publicKey", publicKey, "origin", this.ensureNotNull(origin), "keys", jsonArray));
        return this.getEncryptedResponseAndDecrypt(Message.PASSKEYS_REGISTER.action, nonce);
    }

    public JSONObject passkeysGet(JSONObject publicKey, String origin, List<Map<String, String>> list) throws IOException, KeepassProxyAccessException {
        JSONArray jsonArray = this.checkKeysList(list);
        byte[] nonce = this.sendEncryptedMessage(Map.of("action", Message.PASSKEYS_GET.action, "publicKey", publicKey, "origin", this.ensureNotNull(origin), "keys", jsonArray));
        return this.getEncryptedResponseAndDecrypt(Message.PASSKEYS_GET.action, nonce);
    }

    private String jsonTxt(Map<String, Object> keysValues) {
        return new JSONObject(keysValues).toString();
    }

    private byte[] ramdomGenerateNonce() {
        return TweetNaclFast.randombytes((int)24);
    }

    private byte[] incrementNonce(byte[] nonce) {
        int c = 1;
        byte[] incrementedNonce = (byte[])nonce.clone();
        for (int i = 0; i < nonce.length; ++i) {
            incrementedNonce[i] = (byte)(c += incrementedNonce[i] & 0xFF);
            c >>= 8;
        }
        return incrementedNonce;
    }

    private String b64encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private byte[] b64decode(byte[] bytes) {
        return Base64.getDecoder().decode(bytes);
    }

    private String generateHEXUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private String ensureNotNull(String param) {
        return null == param ? "" : param;
    }

    private JSONArray checkKeysList(List<Map<String, String>> list) throws KeepassProxyAccessException {
        JSONArray array = new JSONArray();
        for (Map<String, String> m : list) {
            JSONObject o = new JSONObject(m);
            if (!o.has("id") || !o.has("key") || o.length() != 2) {
                throw new KeepassProxyAccessException("JSON object key pair is malformed");
            }
            array.put(m);
        }
        return array;
    }

    public String getIdKeyPairPublicKey() {
        return this.credentials.map(value -> this.b64encode(value.getIdKeyPublicKey())).orElse("");
    }

    public String getAssociateId() {
        return this.credentials.map(Credentials::getAssociateId).orElse("");
    }

    public void setCredentials(Optional<Credentials> credentials) {
        this.credentials = credentials;
    }

    protected abstract boolean isConnected();

    public abstract void terminateConnection() throws IOException;

    @Override
    public abstract void close() throws Exception;

    class MessagePublisher
    implements Runnable {
        private boolean doStop = false;
        private int errorCount = 0;

        MessagePublisher() {
        }

        public synchronized void doStop() {
            this.doStop = true;
        }

        private synchronized boolean keepRunning() {
            return !this.doStop;
        }

        @Override
        public void run() {
            while (this.keepRunning()) {
                JSONObject response = Connection.this.getCleartextResponse();
                if (!response.isEmpty()) {
                    if (!Connection.this.isSignal(response)) {
                        LOG.trace("Response added to queue: {}", (Object)response);
                    }
                    Connection.this.queue.offer(response);
                    this.errorCount = 0;
                    continue;
                }
                ++this.errorCount;
                if (this.errorCount <= 4) continue;
                LOG.info("Too much errors - stopping MessagePublisher");
                this.doStop();
                try {
                    Connection.this.terminateConnection();
                }
                catch (IOException e) {
                    LOG.error(e.toString(), e.getCause());
                }
                Connection.this.reconnect();
            }
            LOG.debug("MessagePublisher stopped");
        }
    }

    private static enum Message {
        SET_LOGIN("set-login"),
        GET_LOGINS("get-logins"),
        GENERATE_PASSWORD("generate-password"),
        ASSOCIATE("associate"),
        TEST_ASSOCIATE("test-associate"),
        GET_DATABASE_HASH("get-databasehash"),
        CHANGE_PUBLIC_KEYS("change-public-keys"),
        LOCK_DATABASE("lock-database"),
        DATABASE_LOCKED("database-locked"),
        DATABASE_UNLOCKED("database-unlocked"),
        GET_DATABASE_GROUPS("get-database-groups"),
        CREATE_NEW_GROUP("create-new-group"),
        GET_TOTP("get-totp"),
        REQUEST_AUTOTYPE("request-autotype"),
        PASSKEYS_REGISTER("passkeys-register"),
        PASSKEYS_GET("passkeys-get"),
        DELETE_ENTRY("delete-entry");

        public final String action;

        private Message(String action) {
            this.action = action;
        }
    }

    class MessageConsumer
    implements Callable<JSONObject> {
        private final String action;
        private final byte[] nonce;

        public MessageConsumer(String action, byte[] nonce) {
            this.action = action;
            this.nonce = nonce;
        }

        @Override
        public JSONObject call() throws Exception {
            while (true) {
                JSONObject response;
                if (null == (response = Connection.this.queue.peek())) {
                    Thread.sleep(100L);
                    continue;
                }
                if (Connection.this.isSignal(response)) {
                    Connection.this.queue.remove(response);
                    continue;
                }
                if (response.toString().equals("{}")) {
                    Connection.this.queue.remove(response);
                    LOG.trace("KeePassXC send an empty response: {}", (Object)response);
                    continue;
                }
                for (JSONObject message : Connection.this.queue) {
                    LOG.trace("Checking in queue message {}, looking for action '{}' and nonce {}", new Object[]{message, this.action, Connection.this.b64encode(Connection.this.incrementNonce(this.nonce))});
                    if (message.has("error") && message.getString("action").equals(this.action)) {
                        Connection.this.queue.remove(message);
                        LOG.trace("Found in and retrieved from queue: {}", (Object)message);
                        return message;
                    }
                    if (!message.has("action") || !message.getString("action").equals(this.action) || !message.has("nonce") || !message.getString("nonce").equals(Connection.this.b64encode(Connection.this.incrementNonce(this.nonce)))) continue;
                    Connection.this.queue.remove(message);
                    LOG.trace("Retrieved from queue: {}", (Object)message);
                    return message;
                }
                Thread.sleep(500L);
            }
        }
    }
}

