/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.vm.impl;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.list.TIntList;
import gnu.trove.stack.TIntStack;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Supplier;
import org.protelis.vm.CodePath;
import org.protelis.vm.CodePathFactory;

@SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="False positive, checked by a test.")
public class HashingCodePathFactory
implements CodePathFactory {
    private static final long serialVersionUID = 1L;
    private final HasherSupplier algorithm;

    public HashingCodePathFactory(HasherSupplier hashFunction) {
        this.algorithm = hashFunction;
    }

    public HashingCodePathFactory(HashFunction hashFunction) {
        this(() -> ((HashFunction)hashFunction).newHasher());
    }

    @Override
    public final CodePath createCodePath(TIntList callStackIdentifiers, TIntStack callStackSizes) {
        Hasher hasher = (Hasher)this.algorithm.get();
        callStackIdentifiers.forEach(it -> {
            hasher.putInt(it);
            return true;
        });
        return new HashingCodePath(hasher.hash().asBytes(), false);
    }

    public static final class HashingCodePath
    implements CodePath {
        private static final long serialVersionUID = 1L;
        private final byte[] hash;

        public HashingCodePath(byte[] hash) {
            this(hash, true);
        }

        private HashingCodePath(byte[] hash, boolean copy) {
            if (hash.length < 4) {
                throw new IllegalArgumentException("Hashes shorter than four bytes are unacceptable: " + Arrays.toString(hash));
            }
            this.hash = copy ? Arrays.copyOf(hash, hash.length) : hash;
        }

        public boolean equals(Object obj) {
            return obj instanceof HashingCodePath && Arrays.equals(this.hash, ((HashingCodePath)obj).hash);
        }

        public byte[] getHash() {
            return Arrays.copyOf(this.hash, this.hash.length);
        }

        public int hashCode() {
            return this.hash[0] & 0xFF | (this.hash[1] & 0xFF) << 8 | (this.hash[2] & 0xFF) << 16 | (this.hash[3] & 0xFF) << 24;
        }

        public String toString() {
            return Base64.getEncoder().encodeToString(this.hash);
        }
    }

    @FunctionalInterface
    public static interface HasherSupplier
    extends Supplier<Hasher>,
    Serializable {
    }
}

