/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.vm.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.Reference;
import org.protelis.vm.CodePath;
import org.protelis.vm.CodePathFactory;
import org.protelis.vm.ExecutionContext;
import org.protelis.vm.ExecutionEnvironment;
import org.protelis.vm.NetworkManager;
import org.protelis.vm.impl.DefaultTimeEfficientCodePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutionContext<S extends AbstractExecutionContext<S>>
implements ExecutionContext {
    private static final int MASK = 255;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionContext.class);
    private final TIntStack callFrameSizes = new TIntArrayStack();
    private final TIntList callStack = new TIntArrayList(10, -1);
    private final CodePathFactory codePathFactory;
    private int deferredExportSize;
    private final ExecutionEnvironment environment;
    private int exportsSize;
    private Optional<Map<Reference, ?>> functions = Optional.empty();
    private Map<Reference, Object> gamma;
    private final NetworkManager networkManager;
    private Number previousRoundTime;
    private final List<AbstractExecutionContext<S>> restrictedContexts = Lists.newArrayList();
    private Map<DeviceUID, Map<CodePath, Object>> theta;
    private Map<CodePath, Supplier<?>> tobeComputedBeforeSending;
    private Map<CodePath, Object> toSend;
    private Map<CodePath, Object> toStore;
    private Map<CodePath, Object> lastStored = Collections.emptyMap();
    private int variablesSize;

    protected AbstractExecutionContext(ExecutionEnvironment execenv, NetworkManager netmgr) {
        this(execenv, netmgr, (stack, sizes) -> new DefaultTimeEfficientCodePath(stack));
    }

    protected AbstractExecutionContext(ExecutionEnvironment executionEnvironment, NetworkManager networkManager, CodePathFactory codePathFactory) {
        this.networkManager = Objects.requireNonNull(networkManager);
        this.environment = Objects.requireNonNull(executionEnvironment);
        this.codePathFactory = codePathFactory;
    }

    @Override
    public final <T, R> Field<R> buildField(Function<T, R> computeValue, T localValue) {
        return this.buildField(computeValue, localValue, this.toSend, localValue);
    }

    private <T, D, R> Field<R> buildField(Function<T, R> computeValue, T localValue, Map<CodePath, D> destination, D toBeSent) {
        CodePath codePath = this.codePathFactory.createCodePath(this.callStack, this.callFrameSizes);
        Field.Builder<R> builder = DatatypeFactory.createFieldBuilder();
        for (Map.Entry<DeviceUID, Map<CodePath, Object>> e : this.theta.entrySet()) {
            Object received = e.getValue().get(codePath);
            if (received == null) continue;
            builder.add(e.getKey(), computeValue.apply(received));
        }
        if (destination.putIfAbsent(codePath, toBeSent) != null) {
            throw new IllegalStateException("This program has attempted to build a field twice with the same code path. This is probably a bug in Protelis. Debug information: tried to insert " + codePath + " into " + this.toSend + ". Value to insert: " + localValue + ", existing one: " + this.toSend.get(codePath));
        }
        return builder.build(this.getDeviceUID(), computeValue.apply(Objects.requireNonNull(localValue)));
    }

    @Override
    public final <T, R> Field<R> buildFieldDeferred(Function<T, R> computeValue, T currentLocal, Supplier<T> toBeSent) {
        return this.buildField(computeValue, currentLocal, this.tobeComputedBeforeSending, toBeSent);
    }

    @Override
    public final void commit() {
        this.tobeComputedBeforeSending.forEach((codepath, supplier) -> {
            Object computed = supplier.get();
            Object previous = this.toSend.putIfAbsent((CodePath)codepath, computed);
            if (previous != null) {
                throw new IllegalStateException("Duplicated field entry with the same codepath caused by the computation of a deferred build field: this is likely a bug in Protelis.\ncodepath: " + codepath + "\npreviously: " + previous + "\ncomputed: " + computed + "\noverall exports: " + this.toSend + "\noverall deferred exports: " + this.tobeComputedBeforeSending);
            }
        });
        this.networkManager.shareState(this.toSend);
        this.exportsSize = this.toSend.size();
        this.variablesSize = this.gamma.size();
        this.deferredExportSize = this.tobeComputedBeforeSending.size();
        this.commitRecursively();
    }

    protected final void commitRecursively() {
        Objects.requireNonNull(this.environment);
        Objects.requireNonNull(this.gamma);
        Objects.requireNonNull(this.theta);
        Objects.requireNonNull(this.toSend);
        Objects.requireNonNull(this.toStore);
        Objects.requireNonNull(this.tobeComputedBeforeSending);
        Objects.requireNonNull(this.functions);
        this.previousRoundTime = this.getCurrentTime();
        this.environment.commit();
        this.gamma = null;
        this.theta = null;
        this.toSend = null;
        this.lastStored = Collections.unmodifiableMap(this.toStore);
        this.toStore = null;
        this.tobeComputedBeforeSending = null;
        for (AbstractExecutionContext<S> rctx : this.restrictedContexts) {
            rctx.commitRecursively();
        }
        this.restrictedContexts.clear();
    }

    @Override
    public Number getDeltaTime() {
        Class<?> tClass = Optional.of(this.previousRoundTime).orElse(0.0).getClass();
        if (tClass == Integer.class || tClass == Long.class || tClass == Short.class || tClass == Byte.class) {
            return this.getCurrentTime().longValue() - this.previousRoundTime.longValue();
        }
        return this.getCurrentTime().doubleValue() - this.previousRoundTime.doubleValue();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="This is intentional")
    public final ExecutionEnvironment getExecutionEnvironment() {
        return this.environment;
    }

    protected final Map<Reference, ?> getFunctions() {
        return this.functions.orElseGet(Collections::emptyMap);
    }

    protected final NetworkManager getNetworkManager() {
        return this.networkManager;
    }

    public final <P> P getPersistent(Supplier<P> ifAbsent) {
        CodePath path = this.codePathFactory.createCodePath(this.callStack, this.callFrameSizes);
        Object last = this.lastStored.get(path);
        return (P)(last == null ? ifAbsent.get() : last);
    }

    @Override
    public final Object getVariable(Reference name) {
        return this.gamma.get(name);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The field is unmodifiable")
    public final Map<CodePath, Object> getStoredState() {
        return this.lastStored;
    }

    protected abstract S instance();

    @Override
    public final void newCallStackFrame(byte ... id) {
        int expectedSize = id.length / 4 + Math.min(id.length % 4, 1);
        int[] compact = new int[expectedSize];
        IntBuffer buffer = ByteBuffer.wrap(id).asIntBuffer();
        int bufferSize = buffer.remaining();
        buffer.get(compact, 0, bufferSize);
        if (bufferSize != expectedSize) {
            for (int i = 0; i < id.length % 4; ++i) {
                int n = expectedSize - 1;
                compact[n] = compact[n] | (id[id.length - 1 - i] & 0xFF) << i * 8;
            }
        }
        this.newCallStackFrame(compact);
    }

    @Override
    public final void newCallStackFrame(int ... id) {
        if (id.length < 1) {
            throw new IllegalArgumentException("Unable to push unidentified stack frame: frame id cannot be empty");
        }
        this.callFrameSizes.push(id.length);
        this.callStack.add(id);
    }

    @Override
    public final void putMultipleVariables(Map<Reference, ?> map) {
        this.gamma.putAll(map);
    }

    @Override
    public final void putVariable(Reference name, Object value) {
        this.gamma.put(name, value);
    }

    public final S restrictDomain(@Nonnull Field<?> f) {
        S correctlyTypedInstance;
        if (f.size() > this.theta.size()) {
            throw new IllegalArgumentException("Cannot expand domains. Current: " + this.theta.keySet() + ", desired: " + f.keys());
        }
        if (f.size() == this.theta.size()) {
            return (S)this;
        }
        ImmutableMap restricted = (ImmutableMap)this.theta.entrySet().stream().filter(it -> f.containsKey((DeviceUID)it.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        S restrictedInstance = correctlyTypedInstance = this.instance();
        ((AbstractExecutionContext)restrictedInstance).theta = restricted;
        ((AbstractExecutionContext)restrictedInstance).gamma = this.gamma;
        ((AbstractExecutionContext)restrictedInstance).toSend = this.toSend;
        ((AbstractExecutionContext)restrictedInstance).tobeComputedBeforeSending = this.tobeComputedBeforeSending;
        ((AbstractExecutionContext)restrictedInstance).callStack.addAll((TIntCollection)this.callStack);
        ((AbstractExecutionContext)restrictedInstance).functions = this.functions;
        ((AbstractExecutionContext)restrictedInstance).exportsSize = this.exportsSize;
        ((AbstractExecutionContext)restrictedInstance).variablesSize = this.variablesSize;
        ((AbstractExecutionContext)restrictedInstance).previousRoundTime = this.previousRoundTime;
        ((AbstractExecutionContext)restrictedInstance).toStore = this.toStore;
        ((AbstractExecutionContext)restrictedInstance).lastStored = this.lastStored;
        this.restrictedContexts.add((AbstractExecutionContext<S>)restrictedInstance);
        return correctlyTypedInstance;
    }

    @Override
    public final void returnFromCallFrame() {
        int size = this.callFrameSizes.pop();
        this.callStack.remove(this.callStack.size() - size, size);
    }

    @Override
    public final <T> T runInNewStackFrame(int id, Function<ExecutionContext, T> operation) {
        this.newCallStackFrame(id);
        T result = operation.apply(this);
        this.returnFromCallFrame();
        return result;
    }

    @Override
    public final void setGloballyAvailableReferences(Map<Reference, ?> knownFunctions) {
        if (this.functions.isPresent()) {
            throw new IllegalStateException("Globally available references cannot be set twice");
        }
        this.functions = Optional.of(knownFunctions);
    }

    @Override
    public final void setPersistent(Object o) {
        CodePath path = this.codePathFactory.createCodePath(this.callStack, this.callFrameSizes);
        if (o == null) {
            this.toStore.remove(path);
        } else {
            Object previous = this.toStore.put(path, o);
            if (previous != null) {
                throw new IllegalStateException("This program tried to persist two objects within the same code path.\n Previously inserted " + previous + ": " + previous.getClass().getName() + "\n and then " + o + ": " + o.getClass().getName());
            }
        }
    }

    @Override
    public final void setup() {
        if (this.previousRoundTime == null) {
            this.previousRoundTime = this.getCurrentTime();
        }
        assert (this.previousRoundTime != null) : "Round time is null.";
        this.callStack.clear();
        this.environment.setup();
        this.toSend = Maps.newLinkedHashMapWithExpectedSize((int)this.exportsSize);
        this.tobeComputedBeforeSending = Maps.newLinkedHashMapWithExpectedSize((int)this.deferredExportSize);
        this.toStore = Maps.newLinkedHashMapWithExpectedSize((int)this.lastStored.size());
        this.gamma = Maps.newLinkedHashMapWithExpectedSize((int)this.variablesSize);
        this.gamma.putAll(this.functions.orElseGet(Collections::emptyMap));
        this.theta = Collections.unmodifiableMap(this.networkManager.getNeighborState());
        if (this.theta.containsKey(this.getDeviceUID())) {
            LOGGER.warn("Local device UID {} was included in the set of received messages, indicating that an auto-arc was present in your network configuration. This is being worked around by not considering such information, however, you should fix your logical netowrk.", (Object)this.getDeviceUID());
            ImmutableMap.Builder immutableMap = ImmutableMap.builderWithExpectedSize((int)(this.theta.size() - 1));
            this.theta.forEach((id, object) -> {
                if (!id.equals(this.getDeviceUID())) {
                    immutableMap.put(id, object);
                }
            });
            this.theta = immutableMap.build();
        }
        this.newCallStackFrame(Bytecode.INIT.getCode());
    }
}

