/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.Fields;
import org.protelis.lang.datatype.Unit;
import org.protelis.vm.ExecutionContext;

public final class ReflectionUtils {
    private static final int CACHE_MAX_SIZE = 1000;
    private static final LoadingCache<Triple<Class<?>, String, List<Class<?>>>, Method> METHOD_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.HOURS).build(new CacheLoader<Triple<Class<?>, String, List<Class<?>>>, Method>(){

        public Method load(@Nonnull Triple<Class<?>, String, List<Class<?>>> key) {
            List al = (List)key.getRight();
            Class[] args = new Class[al.size()];
            return ReflectionUtils.loadBestMethod((Class)key.getLeft(), (String)key.getMiddle(), al.toArray(args));
        }
    });
    private static final Map<Class<?>, Function<Number, ? extends Number>> NUMBER_CASTER = ImmutableMap.builder().put(Byte.class, Number::byteValue).put(Byte.TYPE, Number::byteValue).put(Short.class, Number::shortValue).put(Short.TYPE, Number::shortValue).put(Integer.class, Number::intValue).put(Integer.TYPE, Number::intValue).put(Long.class, Number::longValue).put(Long.TYPE, Number::longValue).put(Float.class, Number::floatValue).put(Float.TYPE, Number::floatValue).put(Double.class, Number::doubleValue).put(Double.TYPE, Number::doubleValue).build();

    private ReflectionUtils() {
    }

    private static Number castIfNeeded(Class<?> dest, Number arg) {
        Objects.requireNonNull(dest);
        Objects.requireNonNull(arg);
        if (dest.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        Function<Number, ? extends Number> cast = NUMBER_CASTER.get(dest);
        if (cast != null) {
            return cast.apply(arg);
        }
        throw new IllegalStateException("Impossible cast from " + arg.getClass() + " to " + dest);
    }

    private static boolean classIsNumber(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz) || NUMBER_CASTER.containsKey(clazz);
    }

    private static boolean classIsPrimitive(Class<?> clazz) {
        return Primitives.allPrimitiveTypes().contains(clazz);
    }

    private static boolean classIsWrapper(Class<?> clazz) {
        return Primitives.allWrapperTypes().contains(clazz);
    }

    private static boolean compatibleLength(@Nonnull Method m, int args, @Nullable boolean toBeInjected) {
        Class<?>[] paramTypes = Objects.requireNonNull(m, "Invoked method cannot be null.").getParameterTypes();
        int actualArgsLength = (toBeInjected ? 1 : 0) + args;
        return m.isVarArgs() ? actualArgsLength >= paramTypes.length - 1 : actualArgsLength == paramTypes.length;
    }

    private static boolean compatibleLength(@Nonnull Method m, int args, @Nullable Class<?> firstArgType) {
        return ReflectionUtils.compatibleLength(m, args, ReflectionUtils.willBeInjected(m, firstArgType));
    }

    private static int computePointsForWrapper(Class<?> primitive, Class<?> wrapper) {
        Class wrapped = ClassUtils.primitiveToWrapper(primitive);
        if (wrapped.equals(wrapper)) {
            return 2;
        }
        if (wrapped.isAssignableFrom(wrapper)) {
            return 1;
        }
        return 0;
    }

    private static String formatArguments(Object[] args) {
        return Arrays.stream(args).map(it -> it + ": " + it.getClass().getSimpleName()).collect(Collectors.joining(",", "(", ")"));
    }

    public static Object invokeFieldable(ExecutionContext context, Class<?> clazz, String methodName, Object target, Object[] args) {
        if (Field.class.isAssignableFrom(clazz) && target instanceof Field) {
            return ReflectionUtils.invokeFieldable(context, ((Field)target).getExpectedType(), methodName, target, args);
        }
        return ReflectionUtils.invokeFieldable(context, ReflectionUtils.searchBestMethod(clazz, methodName, args), target, args);
    }

    public static Object invokeFieldable(@Nonnull ExecutionContext context, @Nonnull Method toInvoke, @Nullable Object target, @Nonnull Object[] args) {
        boolean toBeInjected = ReflectionUtils.willBeInjected(toInvoke, args);
        if (!ReflectionUtils.compatibleLength(toInvoke, args.length, toBeInjected)) {
            throw new IllegalArgumentException("Number of parameters of " + toInvoke + " does not match the provided array " + Arrays.toString(args));
        }
        boolean fieldTarget = target instanceof Field;
        TIntArrayList fieldIndexes = new TIntArrayList(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Field) || Field.class.isAssignableFrom(ReflectionUtils.nthArgumentType(toInvoke, toBeInjected ? i + 1 : i))) continue;
            fieldIndexes.add(i);
        }
        if (fieldTarget || fieldIndexes.size() > 0) {
            return Fields.apply((actualT, actualA) -> ReflectionUtils.invokeMethod(context, toInvoke, actualT, actualA), fieldTarget, fieldIndexes.toArray(), target, args);
        }
        return ReflectionUtils.invokeMethod(context, toInvoke, target, args);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="we need to intercept all runtime events")
    private static Object invokeMethod(@Nonnull ExecutionContext context, @Nonnull Method method, @Nullable Object target, @Nonnull Object[] args) {
        Object[] useArgs = ReflectionUtils.repackageIfRequired(context, method, args);
        try {
            return ReflectionUtils.invokePossiblyVoidMethod(method, target, useArgs);
        }
        catch (Exception exc) {
            String errorMessage;
            if (useArgs.length == 0) {
                throw new IllegalStateException(exc);
            }
            Class<?>[] params = method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                Class<?> expected = params[i];
                Object actual = useArgs[i];
                if (expected.isAssignableFrom(actual.getClass()) || !ReflectionUtils.classIsNumber(expected) || !(actual instanceof Number)) continue;
                useArgs[i] = ReflectionUtils.castIfNeeded(expected, (Number)actual);
            }
            try {
                return ReflectionUtils.invokePossiblyVoidMethod(method, target, useArgs);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException("Method " + method + " cannot get invoked because it is not accessible.", e);
            }
            catch (IllegalArgumentException e) {
                boolean isStatic = target == null;
                errorMessage = Optional.ofNullable(e.getMessage()).orElse("Probable argument type mismatch") + ": cannot invoke " + method + " with arguments " + ReflectionUtils.formatArguments(useArgs) + (String)(isStatic ? "" : " on " + target);
                throw new UnsupportedOperationException(errorMessage, e);
            }
            catch (InvocationTargetException e) {
                Throwable rootCause = e.getCause();
                errorMessage = "Invocation of " + method + (String)(target == null ? "" : " on " + target) + " with arguments " + ReflectionUtils.formatArguments(useArgs) + " failed because of an internal " + (rootCause == null ? "unidentified error" : rootCause.getClass().getSimpleName()) + "; please look at the stacktrace for further information";
                throw new UnsupportedOperationException(errorMessage, e);
            }
        }
    }

    private static Object invokePossiblyVoidMethod(@Nonnull Method method, @Nullable Object target, @Nonnull Object[] args) throws IllegalAccessException, InvocationTargetException {
        Object result = method.invoke(target, args);
        if (result == null && method.getReturnType().equals(Void.TYPE)) {
            return Unit.UNIT;
        }
        return result;
    }

    private static Method loadBestMethod(Class<?> clazz, String methodName, Class<?>[] argClass) {
        Objects.requireNonNull(clazz, "The class on which the method will be invoked can not be null.");
        Objects.requireNonNull(methodName, "Method name can not be null.");
        Objects.requireNonNull(argClass, "Method arguments can not be null.");
        Method[] candidates = (Method[])Arrays.stream(clazz.getMethods()).filter(m -> ReflectionUtils.compatibleLength(m, argClass.length, argClass.length > 0 ? argClass[0] : null)).filter(m -> m.getName().equals(methodName)).map(MethodUtils::getAccessibleMethod).filter(Objects::nonNull).toArray(Method[]::new);
        if (candidates.length == 0) {
            throw new IllegalArgumentException("No accessible method named " + methodName + " callable with " + Arrays.toString(argClass) + " parameters is available in " + clazz);
        }
        if (candidates.length == 1 && argClass.length == 0) {
            return candidates[0];
        }
        ArrayList<ImmutablePair> lm = new ArrayList<ImmutablePair>(candidates.length);
        for (Method m2 : candidates) {
            Class<?>[] actualArgClass;
            Class<?>[] expectedParameters = m2.getParameterTypes();
            if (ReflectionUtils.shouldPushContext(expectedParameters, argClass)) {
                actualArgClass = new Class[argClass.length + 1];
                actualArgClass[0] = ExecutionContext.class;
                System.arraycopy(argClass, 0, actualArgClass, 1, argClass.length);
            } else {
                actualArgClass = argClass;
            }
            boolean compatible = true;
            int p = 0;
            for (int i = 0; compatible && i < actualArgClass.length; ++i) {
                Class<?> expected = ReflectionUtils.nthArgumentType(m2, i);
                Class<?> actual = actualArgClass[i];
                if (actual == null && !ReflectionUtils.classIsPrimitive(expected) || expected.isAssignableFrom(actual)) {
                    p += 3;
                    continue;
                }
                if (ExecutionContext.class.isAssignableFrom(expected)) {
                    p += 3;
                    continue;
                }
                if (ReflectionUtils.classIsPrimitive(expected) && ReflectionUtils.classIsWrapper(actual)) {
                    p += ReflectionUtils.computePointsForWrapper(expected, actual);
                    continue;
                }
                if (ReflectionUtils.classIsPrimitive(actual) && ReflectionUtils.classIsWrapper(expected)) {
                    p += ReflectionUtils.computePointsForWrapper(actual, expected);
                    continue;
                }
                if (ReflectionUtils.classIsNumber(expected) && ReflectionUtils.classIsWrapper(actual)) continue;
                compatible = false;
            }
            if (!compatible) continue;
            if (candidates.length == 1) {
                return m2;
            }
            lm.add(new ImmutablePair((Object)p, (Object)m2));
        }
        return lm.stream().max(Comparator.comparing(Pair::getKey)).map(Pair::getValue).orElseThrow(() -> new IllegalStateException("Method selection for " + methodName + " inside " + clazz + " has been restricted to " + Arrays.toString(candidates) + " however none of them is compatible with arguments " + Arrays.toString(argClass)));
    }

    private static Class<?> nthArgumentType(Method m, int n) {
        Class<?>[] expectedArgs = m.getParameterTypes();
        if (m.isVarArgs() && n >= expectedArgs.length - 1) {
            Class<?> varargType = expectedArgs[expectedArgs.length - 1];
            return varargType.getComponentType();
        }
        return expectedArgs[n];
    }

    private static Object[] repackageIfRequired(@Nonnull ExecutionContext context, @Nonnull Method m, @Nonnull Object[] args) {
        Class<?>[] expectedArgs = m.getParameterTypes();
        boolean pushContext = ReflectionUtils.shouldPushContext(expectedArgs, args);
        if (m.isVarArgs() || pushContext) {
            int start;
            Object[] newargs = new Object[expectedArgs.length];
            if (pushContext) {
                newargs[0] = context;
                start = 1;
            } else {
                start = 0;
            }
            int copiedArgCount = expectedArgs.length - start - (m.isVarArgs() ? 1 : 0);
            System.arraycopy(args, 0, newargs, start, Math.max(copiedArgCount, 0));
            if (m.isVarArgs()) {
                int numVarArgs = args.length - copiedArgCount;
                Class<?> varargType = expectedArgs[copiedArgCount];
                Object[] vararg = (Object[])Array.newInstance(varargType.getComponentType(), numVarArgs);
                if (numVarArgs >= 0) {
                    System.arraycopy(args, expectedArgs.length - 1, vararg, 0, numVarArgs);
                }
                newargs[newargs.length - 1] = vararg;
            }
            return newargs;
        }
        return args;
    }

    private static Method searchBestMethod(Class<?> clazz, String methodName, List<Object> args) {
        ArrayList originalClasses = new ArrayList(args.size());
        ArrayList fieldedClasses = new ArrayList(args.size());
        boolean atLeastOneField = false;
        for (Object arg : args) {
            if (arg == null) {
                originalClasses.add(null);
                fieldedClasses.add(null);
                continue;
            }
            Class<?> argClass = arg.getClass();
            if (arg instanceof Field) {
                fieldedClasses.add(((Field)arg).getExpectedType());
                atLeastOneField = true;
            } else {
                fieldedClasses.add(argClass);
            }
            originalClasses.add(argClass);
        }
        try {
            return (Method)METHOD_CACHE.get((Object)new ImmutableTriple(clazz, (Object)methodName, originalClasses));
        }
        catch (UncheckedExecutionException | ExecutionException outerException) {
            if (atLeastOneField) {
                try {
                    return (Method)METHOD_CACHE.get((Object)new ImmutableTriple(clazz, (Object)methodName, fieldedClasses));
                }
                catch (ExecutionException e) {
                    throw new UnsupportedOperationException("No" + methodName + originalClasses + " nor " + methodName + fieldedClasses + " exist in " + clazz + ".\nYou tried to invoke it with arguments " + args, e);
                }
            }
            StringBuilder paramClasses = new StringBuilder(((Object)originalClasses).toString());
            paramClasses.setCharAt(0, '(');
            paramClasses.setCharAt(paramClasses.length() - 1, ')');
            throw new UnsupportedOperationException(methodName + paramClasses + " does not exist in " + clazz + ".\nYou tried to invoke it with arguments " + args, outerException);
        }
    }

    private static Method searchBestMethod(Class<?> clazz, String methodName, Object ... args) {
        return ReflectionUtils.searchBestMethod(clazz, methodName, Arrays.asList(args));
    }

    private static boolean shouldPushContext(Class<?>[] expectedArgs, Class<?>[] argClass) {
        return ReflectionUtils.shouldPushContext(expectedArgs, argClass.length, argClass.length == 0 ? null : argClass[0]);
    }

    private static boolean shouldPushContext(Class<?>[] expectedArgs, int argLength, Class<?> firstArgClass) {
        return expectedArgs.length == argLength + 1 && ExecutionContext.class.isAssignableFrom(expectedArgs[0]) && (firstArgClass == null || !ExecutionContext.class.isAssignableFrom(firstArgClass));
    }

    private static boolean shouldPushContext(Class<?>[] expectedArgs, Object[] args) {
        return ReflectionUtils.shouldPushContext(expectedArgs, args.length, args.length == 0 || args[0] == null ? null : args[0].getClass());
    }

    private static boolean willBeInjected(@Nonnull Method m, @Nullable Class<?> firstArgType) {
        return m.getParameterTypes().length > 0 && ExecutionContext.class.isAssignableFrom(m.getParameterTypes()[0]) && (firstArgType == null || !ExecutionContext.class.isAssignableFrom(firstArgType));
    }

    private static boolean willBeInjected(@Nonnull Method m, @Nonnull Object[] args) {
        return ReflectionUtils.willBeInjected(m, args.length > 0 && args[0] != null ? args[0].getClass() : null);
    }
}

