/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.util;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.All;
import org.protelis.lang.interpreter.impl.FunctionCall;
import org.protelis.lang.loading.Metadata;

public final class ProtelisRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Deque<ProtelisAST<?>> protelisStackTrace = new LinkedList();

    public ProtelisRuntimeException(@Nonnull Throwable javaCause, ProtelisAST<?> origin) {
        super(javaCause);
        this.protelisStackTrace.add(origin);
    }

    public void fillInStackFrame(ProtelisAST<?> element) {
        this.protelisStackTrace.add(element);
    }

    @Override
    public String getMessage() {
        return Optional.ofNullable(this.getCause().getMessage()).orElse("The cause exception did not provide any useful message") + "\n" + this.getProtelisStacktrace();
    }

    public String getProtelisStacktrace() {
        StringBuilder trace = this.header();
        if (this.stream().noneMatch(it -> it instanceof FunctionCall)) {
            trace.append("\n\tin main script ").append(ProtelisRuntimeException.extractLines(this.protelisStackTrace.getFirst()));
        }
        StringBuilder longTrace = this.header();
        ProtelisAST<?> origin = this.protelisStackTrace.getFirst();
        boolean wasFunction = true;
        for (ProtelisAST<?> current : this.protelisStackTrace) {
            if (!(current instanceof All)) {
                longTrace.append("\n\tat: ").append(current + ProtelisRuntimeException.extractLines(current));
            }
            if (wasFunction) {
                origin = current;
                wasFunction = false;
            }
            if (!(current instanceof FunctionCall)) continue;
            wasFunction = true;
            FunctionDefinition fun = ((FunctionCall)current).getFunctionDefinition();
            trace.append("\n\tat ").append(fun.getName()).append(ProtelisRuntimeException.extractLines(origin));
        }
        trace.append("\nFully detailed interpreter trace:\n").append((CharSequence)longTrace);
        return trace.toString();
    }

    private StringBuilder header() {
        return new StringBuilder(1000).append(this.getClass().getName()).append(": ").append(this.getCause().getMessage());
    }

    private Stream<ProtelisAST<?>> stream() {
        return this.protelisStackTrace.stream();
    }

    private static String extractLines(@Nonnull ProtelisAST<?> origin) {
        int end;
        Metadata meta = origin.getMetadata();
        int start = meta.getStartLine();
        return start == (end = meta.getEndLine()) ? " at line number " + start : " between lines " + start + " and " + end;
    }
}

