/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.Objects;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractProtelisAST;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.Op3;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class TernaryOp
extends AbstractProtelisAST<Object> {
    private static final long serialVersionUID = 2803028109250981637L;
    private final Op3 op;

    public TernaryOp(Metadata metadata, String name, ProtelisAST<?> branch1, ProtelisAST<?> branch2, ProtelisAST<?> branch3) {
        this(metadata, Op3.getOp(name), branch1, branch2, branch3);
    }

    private TernaryOp(Metadata metadata, Op3 operator, ProtelisAST<?> branch1, ProtelisAST<?> branch2, ProtelisAST<?> branch3) {
        super(metadata, branch1, branch2, branch3);
        Objects.requireNonNull(branch1);
        Objects.requireNonNull(branch2);
        Objects.requireNonNull(branch3);
        this.op = operator;
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        return this.op.run(this.evalBranch(context, 0), this.evalBranch(context, 1), this.evalBranch(context, 2));
    }

    private Object evalBranch(ExecutionContext context, int i) {
        return context.runInNewStackFrame(i, this.getBranch(i)::eval);
    }

    @Override
    public String getName() {
        return this.op.toString();
    }

    @Override
    public Bytecode getBytecode() {
        return this.op.getBytecode();
    }
}

