/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.protelis.lang.ProtelisLoadingUtilities;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractProtelisAST;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class FunctionCall
extends AbstractProtelisAST<Object> {
    private static final long serialVersionUID = 4143090001260538814L;
    private final FunctionDefinition functionDefinition;
    private final byte[] stackCode;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="FunctionDefinition is immutable")
    public FunctionCall(Metadata metadata, FunctionDefinition functionDefinition, List<ProtelisAST<?>> args) {
        super(metadata, args);
        Objects.requireNonNull(functionDefinition);
        this.functionDefinition = functionDefinition;
        if (this.functionDefinition.invokerShouldInitializeIt()) {
            if (args.size() > 1) {
                throw new IllegalArgumentException(functionDefinition + " is a lambda expression invokable with none or one parameter (it), but was invoked with " + args + ", which are " + args.size());
            }
        } else if (this.functionDefinition.getParameterCount() != args.size()) {
            throw new IllegalArgumentException(functionDefinition + " must be invoked with " + functionDefinition.getParameterCount() + " arguments, but was invoked with " + args + ", which are " + args.size());
        }
        this.stackCode = this.functionDefinition.getStackCode();
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        context.newCallStackFrame(this.stackCode);
        if (this.functionDefinition.invokerShouldInitializeIt() && this.getBranchesNumber() == 1) {
            context.putVariable(ProtelisLoadingUtilities.IT, context.runInNewStackFrame(0, this.getBranch(0)::eval));
        } else {
            LinkedHashMap arguments = Maps.newLinkedHashMapWithExpectedSize((int)this.getBranchesNumber());
            for (int i = 0; i < this.getBranchesNumber(); ++i) {
                arguments.put(this.functionDefinition.getArgumentByPosition(i), context.runInNewStackFrame(i, this.getBranch(i)::eval));
            }
            context.putMultipleVariables(arguments);
        }
        Object result = this.functionDefinition.getBody().eval(context);
        context.returnFromCallFrame();
        return result;
    }

    @Override
    public Bytecode getBytecode() {
        return Bytecode.FUNCTION_CALL;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The field is immutable")
    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    @Override
    public String getName() {
        return this.functionDefinition.getName();
    }
}

