/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class Either<L, R>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final L left;
    private final R right;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="The value is re-computed as needed upon deserialization")
    private transient int hash;

    private Either(L left, R right) {
        if (left == null && right == null || left != null && right != null) {
            throw new IllegalArgumentException("Either left or right must be null, but not both (left: '" + left + "', right: '" + right + "')");
        }
        this.left = left;
        this.right = right;
    }

    public boolean isLeft() {
        return this.right == null;
    }

    public boolean isRight() {
        return this.left == null;
    }

    public L getLeft() {
        if (this.isLeft()) {
            return this.left;
        }
        throw new IllegalStateException(this + " is a Right either and does not store any value on its left");
    }

    public R getRight() {
        if (this.isRight()) {
            return this.right;
        }
        throw new IllegalStateException(this + " is a Left either and does not store any value on its right");
    }

    public String toString() {
        if (this.isLeft()) {
            return "Left(" + this.left + ")";
        }
        return "Right(" + this.right + ")";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Either either = (Either)other;
        return new EqualsBuilder().append(this.left, either.left).append(this.right, either.right).isEquals();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = new HashCodeBuilder().append(this.left).append(this.right).toHashCode();
        }
        return this.hash;
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Either<L, Object>(value, null);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Either<Object, R>(null, value);
    }
}

