/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.vm.impl;

import java.util.Objects;
import java.util.Optional;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.parser.protelis.ProtelisModule;
import org.protelis.vm.ExecutionContext;
import org.protelis.vm.ProtelisProgram;

public final class SimpleProgramImpl
implements ProtelisProgram {
    private static final long serialVersionUID = -986976491484860840L;
    private static final String DEFAULT_PROGRAM_NAME = "default_module:default_program";
    private final ProtelisAST<?> prog;
    private final String name;

    public SimpleProgramImpl(ProtelisModule source, ProtelisAST<?> program) {
        this(Optional.ofNullable(source).map(ProtelisModule::getName).orElse(DEFAULT_PROGRAM_NAME), program);
    }

    public SimpleProgramImpl(String pName, ProtelisAST<?> program) {
        this.name = Objects.requireNonNull(pName);
        this.prog = Objects.requireNonNull(program);
    }

    @Override
    public Object compute(ExecutionContext context) {
        return this.prog.eval(context);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "\n" + this.prog;
    }
}

