/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.Fields;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.OpUtils;
import org.protelis.lang.interpreter.util.WithBytecode;

public enum Op1 implements WithBytecode
{
    MINUS(Bytecode.UNARY_MINUS, "-", Op1::minus),
    NOT(Bytecode.UNARY_NOT, "!", Op1::not);

    private static final int[] FIELDS;
    private static final Map<String, Op1> MAP;
    private final Bytecode bytecode;
    private final UnaryOperation fun;
    private final String opName;

    private Op1(Bytecode bytecode, String name, UnaryOperation function) {
        this.fun = function;
        this.opName = name;
        this.bytecode = bytecode;
    }

    @Override
    public Bytecode getBytecode() {
        return this.bytecode;
    }

    public Object run(Object a) {
        if (a instanceof Field) {
            return Fields.applyWithSingleParam(this.fun, FIELDS, a);
        }
        return this.fun.apply(a);
    }

    public String toString() {
        return this.opName;
    }

    public static Op1 getOp(String name) {
        Op1 op = MAP.get(name);
        if (op == null) {
            op = Arrays.stream(Op1.values()).filter(o -> o.opName.equals(name)).findFirst().get();
            MAP.put(name, op);
        }
        return op;
    }

    private static double minus(Object o) {
        if (o instanceof Number) {
            return -((Number)o).doubleValue();
        }
        return (Double)OpUtils.unsupported("-", o);
    }

    private static boolean not(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o == false;
        }
        return (Boolean)OpUtils.unsupported("!", o);
    }

    static {
        FIELDS = new int[]{0};
        MAP = new ConcurrentHashMap<String, Op1>();
    }

    private static interface UnaryOperation
    extends UnaryOperator<Object>,
    Serializable {
    }
}

