/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.util;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.math3.util.Pair;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.Tuple;
import org.protelis.lang.datatype.Tuples;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.Op2;
import org.protelis.lang.interpreter.util.WithBytecode;

@Deprecated
public enum HoodOp implements WithBytecode
{
    ALL(Bytecode.HOOD_ALL, HoodOp::all, (List<Pair<Class<?>, Supplier<Object>>>)ImmutableList.of((Object)Pair.create(Boolean.class, () -> true)), Collections.emptyList()),
    ANY(Bytecode.HOOD_ANY, HoodOp::any, (List<Pair<Class<?>, Supplier<Object>>>)ImmutableList.of((Object)Pair.create(Boolean.class, () -> false)), Collections.emptyList()),
    LOCAL(Bytecode.HOOD_LOCAL, HoodOp::local, Collections.emptyList(), Collections.emptyList()),
    MAX(Bytecode.HOOD_MAX, HoodOp::max, (List<Pair<Class<?>, Supplier<Object>>>)ImmutableList.of((Object)Pair.create(Number.class, () -> Double.NEGATIVE_INFINITY)), (List<Pair<Class<?>, Function<Object, Object>>>)ImmutableList.of((Object)Pair.create(Tuple.class, t -> HoodOp.fillTuple(Double.NEGATIVE_INFINITY, (Tuple)t)))),
    MEAN(Bytecode.HOOD_MEAN, HoodOp::mean, (List<Pair<Class<?>, Supplier<Object>>>)ImmutableList.of((Object)Pair.create(Number.class, () -> Double.NaN)), (List<Pair<Class<?>, Function<Object, Object>>>)ImmutableList.of((Object)Pair.create(Tuple.class, t -> HoodOp.fillTuple(Double.NaN, (Tuple)t)))),
    MIN(Bytecode.HOOD_MIN, HoodOp::min, (List<Pair<Class<?>, Supplier<Object>>>)ImmutableList.of((Object)Pair.create(Number.class, () -> Double.POSITIVE_INFINITY)), (List<Pair<Class<?>, Function<Object, Object>>>)ImmutableList.of((Object)Pair.create(Tuple.class, t -> HoodOp.fillTuple(Double.POSITIVE_INFINITY, (Tuple)t)))),
    SUM(Bytecode.HOOD_SUM, HoodOp::sum, (List<Pair<Class<?>, Supplier<Object>>>)ImmutableList.of((Object)Pair.create(Number.class, () -> 0.0)), (List<Pair<Class<?>, Function<Object, Object>>>)ImmutableList.of((Object)Pair.create(Tuple.class, t -> HoodOp.fillTuple(0.0, (Tuple)t)))),
    UNION(Bytecode.HOOD_UNION, HoodOp::union, (List<Pair<Class<?>, Supplier<Object>>>)ImmutableList.of((Object)Pair.create(Object.class, () -> DatatypeFactory.createTuple(new Object[0]))), (List<Pair<Class<?>, Function<Object, Object>>>)ImmutableList.of((Object)Pair.create(Object.class, xva$0 -> DatatypeFactory.createTuple(xva$0))));

    private final Bytecode bytecode;
    private final SerializableFunction defs;
    private final SerializableBiFunction function;

    private HoodOp(Bytecode bytecode, SerializableBiFunction fun, List<Pair<Class<?>, Supplier<Object>>> suppliers, List<Pair<Class<?>, Function<Object, Object>>> cloners) {
        this.function = fun;
        this.defs = field -> {
            Class type = field.getExpectedType();
            for (Pair sup : suppliers) {
                if (!((Class)sup.getFirst()).isAssignableFrom(type)) continue;
                return ((Supplier)sup.getSecond()).get();
            }
            for (Pair cloner : cloners) {
                if (!((Class)cloner.getFirst()).isAssignableFrom(type)) continue;
                return ((Function)cloner.getSecond()).apply(field.values().iterator().next());
            }
            return this.no(type);
        };
        this.bytecode = bytecode;
    }

    @Override
    public Bytecode getBytecode() {
        return this.bytecode;
    }

    private <T> T no(Class<?> c) {
        throw new UnsupportedOperationException(this + " cannot compute on " + c);
    }

    public Object run(Field<Object> target, boolean inclusive) {
        return this.function.apply(target, inclusive);
    }

    private static Object all(Field<Object> f, boolean inclusive) {
        return HoodOp.reduceFieldValues(f, inclusive, HoodOp.ALL.defs, Op2.AND);
    }

    private static Object any(Field<Object> f, boolean inclusive) {
        return HoodOp.reduceFieldValues(f, inclusive, HoodOp.ANY.defs, Op2.OR);
    }

    private static Tuple fillTuple(Object defVal, Tuple in) {
        Object[] r = new Object[in.size()];
        for (int i = 0; i < r.length; ++i) {
            Object value = in.get(i);
            r[i] = value instanceof Tuple ? HoodOp.fillTuple(defVal, (Tuple)value) : defVal;
        }
        return DatatypeFactory.createTuple(r);
    }

    public static HoodOp get(String reducer) {
        return Arrays.stream(HoodOp.values()).filter(ho -> ho.name().equalsIgnoreCase(reducer)).findFirst().orElseThrow(() -> new IllegalArgumentException("No built-in hood operation matches " + reducer));
    }

    private static Object local(Field<Object> f, boolean inclusive) {
        return f.getLocalValue();
    }

    private static Object max(Field<Object> f, boolean inclusive) {
        return HoodOp.reduceFieldValues(f, inclusive, HoodOp.MAX.defs, Op2.MAX);
    }

    private static Object mean(Field<Object> f, boolean inclusive) {
        int size = f.size() + (inclusive ? 1 : 0);
        if (size == 0) {
            return HoodOp.MEAN.defs.apply(f);
        }
        return Op2.DIVIDE.getFunction().apply(HoodOp.sum(f, inclusive), size);
    }

    private static Object min(Field<Object> f, boolean inclusive) {
        return HoodOp.reduceFieldValues(f, inclusive, HoodOp.MIN.defs, Op2.MIN.getFunction());
    }

    private static Object reduceFieldValues(Field<Object> f, boolean inclusive, SerializableFunction defs, Op2 reducer) {
        if (inclusive) {
            return f.foldValuesIncludingLocal(reducer.getFunction());
        }
        return f.reduceValues(reducer.getFunction()).orElseGet(() -> defs.apply(f));
    }

    private static <T> T reduceFieldValues(Field<T> f, boolean inclusive, SerializableFunction defs, BinaryOperator<T> reducer) {
        if (inclusive) {
            return f.foldValuesIncludingLocal(reducer);
        }
        return (T)f.reduceValues(reducer).orElseGet(() -> defs.apply(f));
    }

    private static Object sum(Field<Object> f, boolean inclusive) {
        return HoodOp.reduceFieldValues(f, inclusive, HoodOp.SUM.defs, Op2.PLUS.getFunction());
    }

    private static Tuple union(Field<Object> f, boolean inclusive) {
        Object reduced = HoodOp.reduceFieldValues(f, inclusive, HoodOp.UNION.defs, (a, b) -> {
            Tuple at = a instanceof Tuple ? (Tuple)a : DatatypeFactory.createTuple(a);
            Tuple bt = b instanceof Tuple ? (Tuple)b : DatatypeFactory.createTuple(b);
            return Tuples.union(at, bt);
        });
        return reduced instanceof Tuple ? (Tuple)reduced : DatatypeFactory.createTuple(reduced);
    }

    @FunctionalInterface
    private static interface SerializableFunction
    extends Function<Field<?>, Object>,
    Serializable {
    }

    @FunctionalInterface
    private static interface SerializableBiFunction
    extends BiFunction<Field<Object>, Boolean, Object>,
    Serializable {
    }
}

