/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.impl.AbstractField;

public final class FieldMapImpl<T>
extends AbstractField<T> {
    private static final long serialVersionUID = -2947000086262191216L;
    @Nonnull
    private final DeviceUID local;
    @Nonnull
    private final ImmutableMap<DeviceUID, T> values;

    private FieldMapImpl(@Nonnull DeviceUID local, @Nonnull ImmutableMap<DeviceUID, T> values) {
        this.local = local;
        this.values = values;
    }

    @Override
    public boolean containsKey(DeviceUID id) {
        return this.values.containsKey((Object)id);
    }

    @Override
    public DeviceUID getLocalDevice() {
        return this.local;
    }

    @Override
    public T get(@Nonnull DeviceUID id) {
        Object value = this.values.get((Object)id);
        if (value == null) {
            return super.get(id);
        }
        return (T)value;
    }

    @Override
    public Optional<T> getIfPresent(@Nonnull DeviceUID device) {
        return Optional.ofNullable(this.values.get((Object)device));
    }

    @Override
    public T getLocalValue() {
        return this.get(this.getLocalDevice());
    }

    public ImmutableSet<? extends Map.Entry<DeviceUID, T>> iterable() {
        return this.values.entrySet();
    }

    public ImmutableSet<DeviceUID> keys() {
        return this.values.keySet();
    }

    @Override
    public Stream<DeviceUID> keyStream() {
        return this.values.keySet().stream();
    }

    @Override
    public int size() {
        return this.values.size() - 1;
    }

    @Override
    public Stream<? extends Map.Entry<DeviceUID, T>> stream() {
        return this.values.entrySet().stream();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The field is immutable")
    public ImmutableMap<DeviceUID, T> toMap() {
        return this.values;
    }

    @Override
    public ImmutableCollection<T> values() {
        return this.values.values();
    }

    @Override
    public Stream<T> valueStream() {
        return this.values.values().stream();
    }

    public static final class Builder<T>
    implements Field.Builder<T> {
        private final ImmutableMap.Builder<DeviceUID, T> mapBuilder = ImmutableMap.builder();
        private boolean consumed;

        @Override
        public Field.Builder<T> add(DeviceUID key, T value) {
            this.mapBuilder.put((Object)key, value);
            return this;
        }

        @Override
        public Field<T> build(DeviceUID localKey, T localValue) {
            if (this.consumed) {
                throw new IllegalStateException("A field builder can build only one field");
            }
            this.consumed = true;
            this.mapBuilder.put((Object)localKey, localValue);
            return new FieldMapImpl(localKey, this.mapBuilder.build());
        }
    }
}

