/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.interpreter.util.JavaInteroperabilityUtils;
import org.protelis.vm.ExecutionContext;

public final class Option<E>
implements Serializable {
    public static final Object JAVA_NULL = null;
    private static final Option<Object> EMPTY_OPTION = new Option(com.google.common.base.Optional.absent());
    private static final long serialVersionUID = 1L;
    private static final ImmutableMap<String, Boolean> TESTERS = ImmutableMap.of((Object)"isPresent", (Object)true, (Object)"isNotPresent", (Object)false, (Object)"isEmpty", (Object)false, (Object)"isAbsent", (Object)false);
    private final com.google.common.base.Optional<E> internal;

    private Option(E o) {
        this(com.google.common.base.Optional.fromNullable(o));
    }

    private Option(Optional<E> o) {
        this(o.orElse(null));
    }

    private Option(com.google.common.base.Optional<E> o) {
        this.internal = o;
    }

    public Set<E> asSet() {
        return this.internal.asSet();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Option && this.internal.equals(((Option)obj).internal);
    }

    public Option<E> filter(ExecutionContext ctx, FunctionDefinition test) {
        return this.runProtelis(ctx, test, value -> {
            if (value instanceof Boolean) {
                boolean condition = (Boolean)value;
                if (condition) {
                    return this;
                }
                return Option.empty();
            }
            throw new IllegalStateException("Filter functions must return boolean. Illegal: " + test);
        });
    }

    public Option<E> filter(Predicate<? super E> test) {
        if (this.isPresent() && test.test(this.get())) {
            return this;
        }
        return Option.empty();
    }

    public Option<E> filterNot(ExecutionContext ctx, FunctionDefinition test) {
        return this.filter(ctx, test).isEmpty() ? this : Option.empty();
    }

    public Option<E> filterNot(Predicate<? super E> test) {
        return this.filter(e -> !test.test((Object)e));
    }

    public <X> Option<X> flatMap(ExecutionContext ctx, FunctionDefinition fun) {
        this.runProtelis(ctx, fun, value -> {
            boolean isPresent;
            if (value instanceof Option) {
                Option result = (Option)value;
                if (result.isEmpty()) {
                    return Option.empty();
                }
                return (Option)value;
            }
            if (value instanceof com.google.common.base.Optional) {
                com.google.common.base.Optional result = (com.google.common.base.Optional)value;
                if (result.isPresent()) {
                    return new Option<Object>(result.get());
                }
                return Option.empty();
            }
            if (value instanceof Optional) {
                Optional result = (Optional)value;
                return result.map((? super T o) -> new Option<Object>(o)).orElseGet(Option::empty);
            }
            List methods = Arrays.stream(value.getClass().getMethods()).map(MethodUtils::getAccessibleMethod).filter(Objects::nonNull).collect(Collectors.toList());
            Method tester = methods.stream().filter((? super T it) -> it.getParameterCount() == 0).filter((? super T it) -> it.getReturnType().equals(Boolean.class) || it.getReturnType().equals(Boolean.TYPE)).filter((? super T it) -> TESTERS.containsKey((Object)it.getName())).findFirst().orElseThrow(() -> new IllegalStateException("No method in " + value.getClass() + " has name in " + TESTERS.keySet() + ", expects no parameter, and returns boolean."));
            try {
                isPresent = Boolean.TRUE.equals(TESTERS.get((Object)tester.getName())) == ((Boolean)tester.invoke(value, new Object[0])).booleanValue();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            if (isPresent) {
                Object result;
                Method getter = methods.stream().filter((? super T it) -> it.getParameterCount() == 0).filter((? super T it) -> "get".equals(it.getName())).findFirst().orElseThrow(() -> new IllegalStateException("No method in " + value.getClass() + " named get with no parameter"));
                try {
                    result = getter.invoke(value, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
                if (result == null) {
                    throw new IllegalStateException(value + " is not empty, but its get() method returned null.");
                }
                return new Option<Object>(result);
            }
            return Option.empty();
        });
        throw new IllegalArgumentException("Flat-mapping function must take one parameter and return Option.");
    }

    public <X> Option<X> flatMap(Function<? super E, Option<X>> fun) {
        if (this.isPresent()) {
            return fun.apply(this.get());
        }
        return Option.empty();
    }

    public E get() {
        return (E)this.internal.get();
    }

    public int hashCode() {
        return this.internal.hashCode();
    }

    public boolean isAbsent() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return !this.isPresent();
    }

    public boolean isPresent() {
        return this.internal.isPresent();
    }

    public Option<Object> map(ExecutionContext ctx, FunctionDefinition mapper) {
        return this.runProtelis(ctx, mapper, Option::of);
    }

    public <X> Option<X> map(Function<? super E, ? extends X> mapper) {
        return this.flatMap(it -> Option.of(mapper.apply((Object)it)));
    }

    public Option<E> merge(Option<E> other, BinaryOperator<E> combiner) {
        if (this.isPresent()) {
            if (other.isPresent()) {
                return this.map(it -> combiner.apply(it, other.get()));
            }
            return this;
        }
        return other;
    }

    public Option<? extends E> or(Optional<? extends E> other) {
        return this.isPresent() ? this : other.map(Option::of).orElseGet(Option::empty);
    }

    public Option<? extends E> or(Option<? extends E> other) {
        return this.isPresent() ? this : other;
    }

    public Option<? extends E> or(com.google.common.base.Optional<? extends E> other) {
        return this.isPresent() ? this : Option.of(other.orNull());
    }

    public E orElse(E other) {
        return (E)this.internal.or(other);
    }

    public E orElseGet(ExecutionContext ctx, FunctionDefinition other) {
        if (other.getParameterCount() == 0) {
            return (E)this.internal.or(() -> JavaInteroperabilityUtils.runProtelisFunctionWithJavaArguments(ctx, other, ImmutableList.of()));
        }
        throw new IllegalArgumentException("Optional supplier function must be 0-ary. Illegal function: " + other);
    }

    public E orElseGet(Supplier<? extends E> other) {
        return (E)this.internal.or(other.get());
    }

    public <X extends RuntimeException> E orElseThrow(Supplier<? extends X> exceptionSupplier) {
        if (this.isPresent()) {
            return this.get();
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    private <X> Option<X> runProtelis(ExecutionContext ctx, FunctionDefinition fun, Function<Object, Option<X>> converter) {
        if (fun.getParameterCount() == 1 || fun.invokerShouldInitializeIt()) {
            if (this.isPresent()) {
                Object value = JavaInteroperabilityUtils.runProtelisFunctionWithJavaArguments(ctx, fun, ImmutableList.of(this.get()));
                return converter.apply(value);
            }
            return Option.empty();
        }
        throw new IllegalArgumentException("Protelis function over Option takes a single argument. Illegal: " + fun);
    }

    public com.google.common.base.Optional<E> toGuava() {
        return this.internal;
    }

    public Optional<E> toJavaUtil() {
        return this.internal.toJavaUtil();
    }

    public String toString() {
        return this.isEmpty() ? "Option.None" : "Option.Some(" + this.internal.get() + ")";
    }

    public Option<Object> transform(ExecutionContext ctx, FunctionDefinition mapper) {
        return this.map(ctx, mapper);
    }

    public <X> Option<X> transform(Function<? super E, ? extends X> mapper) {
        return this.map(mapper);
    }

    public static <E> Option<E> absent() {
        return Option.empty();
    }

    public static <E> Option<E> empty() {
        return EMPTY_OPTION;
    }

    public static <E> Option<E> fromGuava(com.google.common.base.Optional<E> origin) {
        return new Option<E>(origin);
    }

    public static <E> Option<E> fromJavaUtil(Optional<E> origin) {
        return new Option<E>(origin);
    }

    public static <E> Option<E> fromNullable(E value) {
        return Option.ofNullable(value);
    }

    public static <E> Option<E> of(E value) {
        return new Option<E>(value);
    }

    public static <E> Option<E> ofNullable(E value) {
        return Option.of(value);
    }
}

