/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.list.array.TByteArrayList;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.protelis.lang.ProtelisLoadingUtilities;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.util.Reference;
import org.protelis.parser.protelis.FunctionDef;
import org.protelis.parser.protelis.Lambda;
import org.protelis.parser.protelis.ShortLambda;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="No need to recover the field, as the body is always generated before serialization")
public final class FunctionDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int argNumber;
    private final List<Reference> args;
    private final String functionName;
    private final boolean initializeIt;
    private final TByteArrayList stackCode;
    private final transient Supplier<ProtelisAST<?>> bodySupplier;
    private ProtelisAST<?> cleanBody;

    public FunctionDefinition(FunctionDef functionDefinition, Supplier<ProtelisAST<?>> bodySupplier) {
        this(ProtelisLoadingUtilities.qualifiedNameFor(functionDefinition), Optional.ofNullable(functionDefinition.getArgs()).flatMap(it -> Optional.ofNullable(it.getArgs())).orElseGet(Collections::emptyList).stream().map(Reference::new).collect(Collectors.toList()), bodySupplier, false);
    }

    public FunctionDefinition(Lambda lambda, List<Reference> args, ProtelisAST<?> body) {
        this(ProtelisLoadingUtilities.qualifiedNameFor(lambda), args, () -> body, lambda instanceof ShortLambda);
    }

    private FunctionDefinition(String name, List<Reference> args, Supplier<ProtelisAST<?>> bodySupplier, boolean maybeOneArgument) {
        this.argNumber = Objects.requireNonNull(args).size();
        if (maybeOneArgument && this.argNumber != 0) {
            throw new IllegalArgumentException("Function has optional 'it' parameter bit requires arguments");
        }
        this.initializeIt = maybeOneArgument;
        if (this.argNumber > 127) {
            throw new IllegalArgumentException("Currently the maximum number of allowed parameters for a function is 127 " + name + " has " + this.argNumber + " parameters.");
        }
        this.functionName = Objects.requireNonNull(name);
        this.args = args;
        byte[] asciibytes = this.functionName.getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = ByteBuffer.allocate(asciibytes.length + 1);
        bb.put((byte)this.argNumber);
        bb.put(asciibytes);
        this.stackCode = new TByteArrayList(bb.array());
        this.bodySupplier = bodySupplier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FunctionDefinition) {
            FunctionDefinition fd = (FunctionDefinition)o;
            return this.functionName.equals(fd.functionName) && this.argNumber == fd.argNumber;
        }
        return false;
    }

    public Reference getArgumentByPosition(int i) {
        return this.args.get(i);
    }

    public ProtelisAST<?> getBody() {
        if (this.cleanBody == null) {
            this.cleanBody = this.bodySupplier.get();
        }
        return this.cleanBody;
    }

    public String getName() {
        return this.functionName;
    }

    public int getParameterCount() {
        return this.argNumber;
    }

    public byte[] getStackCode() {
        return this.stackCode.toArray();
    }

    public int hashCode() {
        return this.functionName.hashCode() + this.argNumber;
    }

    public boolean invokerShouldInitializeIt() {
        return this.initializeIt;
    }

    public String toString() {
        return this.functionName + "/" + this.argNumber;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.getBody();
        stream.defaultWriteObject();
    }
}

