/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Option;
import org.protelis.lang.datatype.impl.LazyField;

public interface Field<T>
extends Serializable {
    default public boolean containsKey(DeviceUID id) {
        return this.foldExcludingLocal(false, it -> ((DeviceUID)it.getKey()).equals(id), Boolean::logicalOr);
    }

    default public Map.Entry<DeviceUID, T> foldExcludingLocal(Map.Entry<DeviceUID, T> base, BinaryOperator<Map.Entry<DeviceUID, T>> combiner) {
        return this.foldExcludingLocal(base, Function.identity(), combiner);
    }

    default public <R> R foldExcludingLocal(R base, Function<Map.Entry<DeviceUID, T>, R> mapper, BinaryOperator<R> combiner) {
        return (R)this.stream().filter(it -> !((DeviceUID)it.getKey()).equals(this.getLocalDevice())).reduce(base, (r, t) -> combiner.apply(mapper.apply((Map.Entry)t), r), combiner);
    }

    default public Map.Entry<DeviceUID, T> foldIncludingLocal(BinaryOperator<Map.Entry<DeviceUID, T>> combiner) {
        return this.foldIncludingLocal(Function.identity(), combiner);
    }

    default public <R> R foldIncludingLocal(Function<Map.Entry<DeviceUID, T>, R> mapper, BinaryOperator<R> combiner) {
        return this.stream().map(mapper).reduce(combiner).orElseThrow(() -> new IllegalStateException("Field with no local. This is a bug in Protelis."));
    }

    default public DeviceUID foldKeysExcludingLocal(DeviceUID base, BinaryOperator<DeviceUID> combiner) {
        return this.foldExcludingLocal(base, Map.Entry::getKey, combiner);
    }

    default public DeviceUID foldKeysIncludingLocal(BinaryOperator<DeviceUID> combiner) {
        return this.foldIncludingLocal(Map.Entry::getKey, combiner);
    }

    default public T foldValuesExcludingLocal(T base, BinaryOperator<T> combiner) {
        return (T)this.foldExcludingLocal(base, Map.Entry::getValue, combiner);
    }

    default public T foldValuesIncludingLocal(BinaryOperator<T> combiner) {
        return (T)this.foldIncludingLocal(Map.Entry::getValue, combiner);
    }

    default public T get(@Nonnull DeviceUID id) {
        return this.getIfPresent(id).orElseThrow(() -> new NoSuchElementException("Device " + id + " is not available in field " + this));
    }

    default public Class<? extends T> getExpectedType() {
        return this.getLocal().getValue().getClass();
    }

    default public Optional<T> getIfPresent(@Nonnull DeviceUID id) {
        return this.stream().filter(it -> ((DeviceUID)it.getKey()).equals(id)).findFirst().map(Map.Entry::getValue);
    }

    default public Map.Entry<DeviceUID, T> getLocal() {
        return new ImmutablePair((Object)this.getLocalDevice(), this.getLocalValue());
    }

    public DeviceUID getLocalDevice();

    default public T getLocalValue() {
        return this.get(this.getLocalDevice());
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterable<? extends Map.Entry<DeviceUID, T>> iterable();

    default public Iterable<DeviceUID> keys() {
        return () -> this.keyStream().iterator();
    }

    default public Stream<DeviceUID> keyStream() {
        return this.stream().map(Map.Entry::getKey);
    }

    default public <R> Field<R> map(@Nonnull Function<DeviceUID, R> mapper) {
        return new LazyField<R>(this, mapper);
    }

    default public Field<T> projectOn(@Nonnull Field<?> restricted) {
        if (restricted.size() > this.size()) {
            throw new IllegalArgumentException("Field cannot possibly get extended");
        }
        if (restricted.size() == this.size()) {
            return this;
        }
        return new LazyField<Object>(restricted, this::get);
    }

    default public Option<Map.Entry<DeviceUID, T>> reduce(@Nonnull BinaryOperator<Map.Entry<DeviceUID, T>> combiner) {
        return this.reduce(Function.identity(), combiner);
    }

    default public <R> Option<R> reduce(@Nonnull Function<Map.Entry<DeviceUID, T>, R> mapper, @Nonnull BinaryOperator<R> combiner) {
        return Option.fromJavaUtil(this.stream().filter(it -> !((DeviceUID)it.getKey()).equals(this.getLocalDevice())).map(mapper).reduce(combiner));
    }

    default public Option<DeviceUID> reduceKeys(@Nonnull BinaryOperator<DeviceUID> combiner) {
        return this.reduce(Map.Entry::getKey, combiner);
    }

    default public Option<T> reduceValues(@Nonnull BinaryOperator<T> combiner) {
        return this.reduce(Map.Entry::getValue, combiner);
    }

    default public int size() {
        return (int)this.stream().count() - 1;
    }

    default public Stream<? extends Map.Entry<DeviceUID, T>> stream() {
        return StreamSupport.stream(this.iterable().spliterator(), false);
    }

    default public Map<DeviceUID, T> toMap() {
        return (Map)this.stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public Iterable<T> values() {
        return () -> this.valueStream().iterator();
    }

    default public Stream<T> valueStream() {
        return this.stream().map(Map.Entry::getValue);
    }

    public static interface Builder<T> {
        public Builder<T> add(DeviceUID var1, T var2);

        public Field<T> build(DeviceUID var1, T var2);
    }
}

