/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.model.type.provider.converter;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.projectodd.jrapidoc.model.object.BeanProperty;
import org.projectodd.jrapidoc.model.object.type.CollectionTypeJrapidoc;
import org.projectodd.jrapidoc.model.object.type.CustomType;
import org.projectodd.jrapidoc.model.object.type.MapTypeJrapidoc;
import org.projectodd.jrapidoc.model.object.type.Type;
import org.projectodd.jrapidoc.model.type.provider.converter.JacksonSignature;

public class JacksonToJrapidocProcessor {
    ObjectMapper objectMapper;
    public static Map<String, Type> cache = new LinkedHashMap<String, Type>();

    public JacksonToJrapidocProcessor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Type getType(SimpleType jacksonType) {
        try {
            String signature = JacksonSignature.createSignature(jacksonType);
            CustomType type = new CustomType(jacksonType.getRawClass().getName(), signature, jacksonType.getRawClass());
            if (cache.containsKey(signature)) {
                return cache.get(signature);
            }
            cache.put(signature, type);
            ObjectWriter objectWriter = this.objectMapper.writerFor((JavaType)jacksonType);
            Field prefetchField = objectWriter.getClass().getDeclaredField("_prefetch");
            prefetchField.setAccessible(true);
            ObjectWriter.Prefetch prefetch = (ObjectWriter.Prefetch)prefetchField.get(objectWriter);
            this.doIntrospection(prefetch.valueSerializer, type);
            return type;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Type getType(CollectionLikeType jacksonType) {
        String signature = JacksonSignature.createSignature(jacksonType);
        JavaType contentType = jacksonType.getContentType();
        String contentSignature = JacksonSignature.createSignature(contentType);
        Class containerClass = jacksonType.getRawClass();
        CollectionTypeJrapidoc type = new CollectionTypeJrapidoc(containerClass.getName(), signature, contentType.getRawClass().getName(), contentSignature);
        if (cache.containsKey(signature)) {
            return cache.get(signature);
        }
        cache.put(signature, type);
        this.getType(jacksonType.getContentType());
        return type;
    }

    public Type getType(ArrayType jacksonType) {
        String signature = JacksonSignature.createSignature(jacksonType);
        String contentSignature = JacksonSignature.createSignature(jacksonType.getContentType());
        Class contentType = jacksonType.getContentType().getRawClass();
        Class containerClass = jacksonType.getRawClass();
        CollectionTypeJrapidoc type = new CollectionTypeJrapidoc(containerClass.getName(), signature, contentType.getName(), contentSignature);
        if (cache.containsKey(signature)) {
            return cache.get(signature);
        }
        cache.put(signature, type);
        this.getType(jacksonType.getContentType());
        return type;
    }

    public Type getType(MapLikeType jacksonType) {
        String signature = JacksonSignature.createSignature(jacksonType);
        JavaType keyType = jacksonType.getKeyType();
        JavaType valueType = jacksonType.getContentType();
        Class containerClass = jacksonType.getRawClass();
        String keySignature = JacksonSignature.createSignature(keyType);
        String valSignature = JacksonSignature.createSignature(valueType);
        MapTypeJrapidoc type = new MapTypeJrapidoc(containerClass.getName(), signature, keyType.getRawClass().getName(), keySignature, valueType.getRawClass().getName(), valSignature);
        if (cache.containsKey(signature)) {
            return cache.get(signature);
        }
        cache.put(signature, type);
        this.getType(keyType);
        this.getType(valueType);
        return type;
    }

    public Type getType(JavaType type) {
        if (type instanceof SimpleType) {
            return this.getType((SimpleType)type);
        }
        if (type instanceof CollectionType) {
            return this.getType((CollectionLikeType)type);
        }
        if (type instanceof ArrayType) {
            return this.getType((ArrayType)type);
        }
        if (type instanceof MapLikeType) {
            return this.getType((MapLikeType)type);
        }
        throw new RuntimeException("Unimplemented Jackson type: " + type);
    }

    private void doIntrospection(JsonSerializer serializer, Type type) {
        if (serializer == null) {
            return;
        }
        if (EnumSerializer.class.isAssignableFrom(serializer.getClass())) {
            this.introspectSerializer((EnumSerializer)serializer, (CustomType)type);
        } else if (BeanSerializerBase.class.isAssignableFrom(serializer.getClass())) {
            this.introspectSerializer((BeanSerializerBase)serializer, (CustomType)type);
        } else if (StdScalarSerializer.class.isAssignableFrom(serializer.getClass())) {
            this.introspectSerializer((StdScalarSerializer)serializer, (CustomType)type);
        } else if (AsArraySerializerBase.class.isAssignableFrom(serializer.getClass())) {
            this.introspectSerializer((AsArraySerializerBase)serializer, (CollectionTypeJrapidoc)type);
        } else if (MapSerializer.class.isAssignableFrom(serializer.getClass())) {
            this.introspectSerializer((MapSerializer)serializer, (MapTypeJrapidoc)type);
        }
    }

    private void introspectSerializer(AsArraySerializerBase collectionSerializer, CollectionTypeJrapidoc type) {
        this.getType(collectionSerializer.getContentType());
    }

    private void introspectSerializer(BeanSerializerBase beanSerializer, CustomType type) {
        try {
            BeanPropertyWriter[] props;
            Field propsField = beanSerializer.getClass().getSuperclass().getDeclaredField("_props");
            propsField.setAccessible(true);
            for (BeanPropertyWriter prop : props = (BeanPropertyWriter[])propsField.get(beanSerializer)) {
                JavaType propType = prop.getType();
                this.getType(propType);
                String signature = JacksonSignature.createSignature(propType);
                type.addBeanProperty(new BeanProperty(prop.getName(), signature, prop.getPropertyType(), prop.getMetadata().getDescription(), prop.getMetadata().isRequired()));
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void introspectSerializer(EnumSerializer enumSerializer, CustomType type) {
        for (SerializableString value : enumSerializer.getEnumValues().values()) {
            type.addEnumeration(value.getValue());
        }
    }

    private void introspectSerializer(MapSerializer mapSerializer, MapTypeJrapidoc type) {
        try {
            Field keyTypeField = mapSerializer.getClass().getDeclaredField("_keyType");
            keyTypeField.setAccessible(true);
            JavaType keyType = (JavaType)keyTypeField.get(mapSerializer);
            JavaType valueType = mapSerializer.getContentType();
            this.getType(keyType);
            this.getType(valueType);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void introspectSerializer(StdScalarSerializer stdScalarSerializer, CustomType type) {
    }

    public Type loadType(JavaType javaType) {
        Type type = this.getType(javaType);
        return type;
    }
}

