/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.model.type.provider.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.projectodd.jrapidoc.model.ModelUtil;

public class JacksonSignature {
    public static String createSignature(JavaType jacksonType) {
        if (jacksonType instanceof SimpleType) {
            return JacksonSignature.createSignature((SimpleType)jacksonType);
        }
        if (jacksonType instanceof CollectionType) {
            return JacksonSignature.createSignature((CollectionLikeType)jacksonType);
        }
        if (jacksonType instanceof ArrayType) {
            return JacksonSignature.createSignature((ArrayType)jacksonType);
        }
        if (jacksonType instanceof MapLikeType) {
            return JacksonSignature.createSignature((MapLikeType)jacksonType);
        }
        throw new RuntimeException("Type not implemented: " + jacksonType);
    }

    public static String createSignature(SimpleType simpleType) {
        ArrayList<Class> parameterClasses = null;
        try {
            Field typeParametersField = simpleType.getClass().getDeclaredField("_typeParameters");
            typeParametersField.setAccessible(true);
            JavaType[] typeParameters = (JavaType[])typeParametersField.get(simpleType);
            parameterClasses = new ArrayList<Class>();
            if (typeParameters != null) {
                for (JavaType javaType : typeParameters) {
                    parameterClasses.add(javaType.getRawClass());
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return ModelUtil.getSimpleTypeSignature(simpleType.getRawClass(), parameterClasses);
    }

    public static String createSignature(CollectionLikeType collectionLikeType) {
        return "array<" + JacksonSignature.createSignature(collectionLikeType.getContentType()) + ">";
    }

    public static String createSignature(ArrayType arrayType) {
        return "array<" + JacksonSignature.createSignature(arrayType.getContentType()) + ">";
    }

    public static String createSignature(MapLikeType mapLikeType) {
        return "map<" + JacksonSignature.createSignature(mapLikeType.getKeyType()) + "," + JacksonSignature.createSignature(mapLikeType.getContentType()) + ">";
    }
}

