/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.model.type.provider;

import org.apache.commons.lang3.StringUtils;
import org.projectodd.jrapidoc.logger.Logger;
import org.projectodd.jrapidoc.model.type.provider.JacksonJsonProvider;
import org.projectodd.jrapidoc.model.type.provider.TypeProvider;

public class TypeProviderFactory {
    public static TypeProvider createTypeProvider(String clazzToLoad, ClassLoader loader) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)clazzToLoad)) {
                Logger.info((String)"Loading class {0}", (String[])new String[]{clazzToLoad});
                Class<?> providerImpl = loader.loadClass(clazzToLoad);
                Logger.debug((String)"Creating new instance from class {0} as TypeProvider", (String[])new String[]{clazzToLoad});
                return (TypeProvider)providerImpl.newInstance();
            }
            Logger.info((String)"Using default TypeProvider instance", (String[])new String[0]);
            return new JacksonJsonProvider();
        }
        catch (Exception e) {
            Logger.warn((Throwable)e, (String)"Exception occured during loading {0} as TypeProvider, using default TypeProvider", (String[])new String[]{clazzToLoad});
            return new JacksonJsonProvider();
        }
    }
}

