/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.model.generator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.projectodd.jrapidoc.exception.JrapidocExecutionException;
import org.projectodd.jrapidoc.logger.Logger;
import org.projectodd.jrapidoc.model.APIModel;

public class ModelGenerator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateModel(APIModel model, File output) throws JrapidocExecutionException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(output);
            ModelGenerator.generateModel(model, outputStream);
            if (outputStream == null) return;
        }
        catch (FileNotFoundException e) {
            try {
                Logger.error((Throwable)e, (String)"File {0} was not found on filesystem", (String[])new String[]{output.getAbsolutePath()});
                throw new JrapidocExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (outputStream == null) throw throwable;
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    Logger.warn((Throwable)e2, (String)"File output stream {0} could not be closed", (String[])new String[]{output.getAbsolutePath()});
                }
                throw throwable;
            }
        }
        try {
            outputStream.close();
            return;
        }
        catch (IOException e) {
            Logger.warn((Throwable)e, (String)"File output stream {0} could not be closed", (String[])new String[]{output.getAbsolutePath()});
            return;
        }
    }

    public static void generateModel(APIModel model, OutputStream output) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(output, (Object)model);
        }
        catch (IOException e) {
            Logger.error((Throwable)e, (String)"Could not write model to output stream", (String[])new String[0]);
        }
    }
}

