/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.projectodd.jrapidoc.logger.Logger;
import org.projectodd.jrapidoc.model.Method;
import org.projectodd.jrapidoc.model.param.CookieParam;
import org.projectodd.jrapidoc.model.param.FormParam;
import org.projectodd.jrapidoc.model.param.HeaderParam;
import org.projectodd.jrapidoc.model.param.MatrixParam;
import org.projectodd.jrapidoc.model.param.Param;
import org.projectodd.jrapidoc.model.param.PathParam;
import org.projectodd.jrapidoc.model.param.QueryParam;

@JsonPropertyOrder(value={"path", "serviceName", "serviceDescription", "pathExample", "methods"})
public class Service {
    private String path;
    private String pathExample;
    @JsonIgnore
    private List<HeaderParam> headerParams = new ArrayList<HeaderParam>();
    @JsonIgnore
    private List<CookieParam> cookieParams = new ArrayList<CookieParam>();
    @JsonIgnore
    private List<FormParam> formParams = new ArrayList<FormParam>();
    @JsonIgnore
    private List<MatrixParam> matrixParams = new ArrayList<MatrixParam>();
    @JsonIgnore
    private List<PathParam> pathParams = new ArrayList<PathParam>();
    @JsonIgnore
    private List<QueryParam> queryParams = new ArrayList<QueryParam>();
    private Map<String, Method> methods = new TreeMap<String, Method>();
    @JsonProperty(value="serviceDescription")
    private String description;
    @JsonProperty(value="serviceName")
    private String name;

    private Service(String path, String pathExample, List<HeaderParam> headerParams, List<CookieParam> cookieParams, List<FormParam> formParams, List<MatrixParam> matrixParams, List<PathParam> pathParams, List<QueryParam> queryParams, Map<String, Method> methods, String description, String name) {
        this.path = path;
        this.pathExample = pathExample;
        this.headerParams = headerParams;
        this.cookieParams = cookieParams;
        this.formParams = formParams;
        this.matrixParams = matrixParams;
        this.pathParams = pathParams;
        this.queryParams = queryParams;
        this.methods = methods;
        this.description = description;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, Method> getMethods() {
        return this.methods;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPathExample() {
        return this.pathExample;
    }

    public List<HeaderParam> getHeaderParams() {
        return this.headerParams;
    }

    public List<CookieParam> getCookieParams() {
        return this.cookieParams;
    }

    public List<FormParam> getFormParams() {
        return this.formParams;
    }

    public List<MatrixParam> getMatrixParams() {
        return this.matrixParams;
    }

    public List<PathParam> getPathParams() {
        return this.pathParams;
    }

    public List<QueryParam> getQueryParams() {
        return this.queryParams;
    }

    private <T extends Param> T getParam(List<T> params, String paramName) {
        for (Param p : params) {
            if (!p.getName().equals(paramName)) continue;
            return (T)p;
        }
        return null;
    }

    public Param getParam(String paramType, String paramName) {
        if (paramType.equals("COOKIE_PARAM")) {
            return this.getParam(this.cookieParams, paramName);
        }
        if (paramType.equals("FORM_PARAM")) {
            return this.getParam(this.formParams, paramName);
        }
        if (paramType.equals("HEADER_PARAM")) {
            return this.getParam(this.headerParams, paramName);
        }
        if (paramType.equals("MATRIX_PARAM")) {
            return this.getParam(this.matrixParams, paramName);
        }
        if (paramType.equals("PATH_PARAM")) {
            return this.getParam(this.pathParams, paramName);
        }
        if (paramType.equals("QUERY_PARAM")) {
            return this.getParam(this.queryParams, paramName);
        }
        return null;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPathExample(String pathExample) {
        this.pathExample = pathExample;
    }

    public void setMethods(Map<String, Method> methods) {
        this.methods = methods;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class ResourceBuilder {
        private String path;
        private String pathExample;
        private List<HeaderParam> headerParams = new ArrayList<HeaderParam>();
        private List<CookieParam> cookieParams = new ArrayList<CookieParam>();
        private List<FormParam> formParams = new ArrayList<FormParam>();
        private List<MatrixParam> matrixParams = new ArrayList<MatrixParam>();
        private List<PathParam> pathParams = new ArrayList<PathParam>();
        private List<QueryParam> queryParams = new ArrayList<QueryParam>();
        private Map<String, Method> methods = new TreeMap<String, Method>();
        private String description;
        private String name;

        public ResourceBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ResourceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ResourceBuilder pathExample(String pathExample) {
            this.pathExample = pathExample;
            return this;
        }

        public ResourceBuilder method(Method method) {
            String key;
            String string = key = StringUtils.isNotEmpty((CharSequence)method.getName()) ? method.getName() : method.getPath();
            if (StringUtils.isNotEmpty((CharSequence)method.getHttpMethodType())) {
                key = key + " - " + method.getHttpMethodType();
            }
            if (key == null) {
                Logger.warn((String)"Putting null key into map!!!", (String[])new String[0]);
            }
            if (this.methods.containsKey(key)) {
                Logger.warn((String)"Method identifier must be unique, but method with identifier {0} already exists!!!", (String[])new String[]{key});
            }
            this.methods.put(key, method);
            return this;
        }

        public ResourceBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ResourceBuilder param(Param.Type paramType, Param param) {
            if (paramType.equals((Object)Param.Type.COOKIE_PARAM)) {
                this.addCookieParam((CookieParam)param);
            } else if (paramType.equals((Object)Param.Type.FORM_PARAM)) {
                this.addFormParam((FormParam)param);
            } else if (paramType.equals((Object)Param.Type.HEADER_PARAM)) {
                this.addHeaderParam((HeaderParam)param);
            } else if (paramType.equals((Object)Param.Type.MATRIX_PARAM)) {
                this.addMatrixParam((MatrixParam)param);
            } else if (paramType.equals((Object)Param.Type.PATH_PARAM)) {
                this.addPathParam((PathParam)param);
            } else if (paramType.equals((Object)Param.Type.QUERY_PARAM)) {
                this.addQueryParam((QueryParam)param);
            }
            return this;
        }

        protected void addHeaderParam(HeaderParam headerParam) {
            for (HeaderParam param : this.headerParams) {
                if (!param.getName().equals(headerParam.getName())) continue;
                return;
            }
            this.headerParams.add(headerParam);
        }

        protected void addCookieParam(CookieParam cookieParam) {
            this.cookieParams.add(cookieParam);
        }

        protected void addFormParam(FormParam formParam) {
            this.formParams.add(formParam);
        }

        protected void addMatrixParam(MatrixParam matrixParam) {
            this.matrixParams.add(matrixParam);
        }

        protected void addPathParam(PathParam pathParam) {
            this.pathParams.add(pathParam);
        }

        protected void addQueryParam(QueryParam queryParam) {
            this.queryParams.add(queryParam);
        }

        public Service build() {
            return new Service(this.path, this.pathExample, this.headerParams, this.cookieParams, this.formParams, this.matrixParams, this.pathParams, this.queryParams, this.methods, this.description, this.name);
        }
    }
}

