/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.jrapidoc.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.projectodd.jrapidoc.logger.Logger;
import org.projectodd.jrapidoc.model.ServiceGroup;
import org.projectodd.jrapidoc.model.object.type.Type;

@JsonPropertyOrder(value={"customInfo", "serviceGroups", "types"})
public class APIModel {
    private Map<String, String> customInfo;
    private Map<String, ServiceGroup> serviceGroups;
    private Map<String, Type> types;

    private APIModel(Map<String, ServiceGroup> serviceGroups, Map<String, Type> types, Map<String, String> customInfo) {
        this.serviceGroups = serviceGroups;
        this.types = types;
        this.customInfo = customInfo;
    }

    public void setCustomInfo(Map<String, String> customInfo) {
        this.customInfo = customInfo;
    }

    public void setTypes(Map<String, Type> types) {
        this.types = types;
    }

    public void setServiceGroups(Map<String, ServiceGroup> serviceGroups) {
        this.serviceGroups = serviceGroups;
    }

    public Map<String, String> getCustomInfo() {
        return this.customInfo;
    }

    public Map<String, Type> getTypes() {
        return this.types;
    }

    public Map<String, ServiceGroup> getServiceGroups() {
        return this.serviceGroups;
    }

    public static class APIModelBuilder {
        private Map<String, ServiceGroup> resourceGroups = new TreeMap<String, ServiceGroup>();
        private Map<String, String> customInfo = new LinkedHashMap<String, String>();
        private Map<String, Type> types;

        public APIModelBuilder resourceGroup(ServiceGroup serviceGroup) {
            String key = serviceGroup.getBaseUrl();
            Logger.debug((String)"Service group identifier: {0}", (String[])new String[]{key});
            if (key == null) {
                Logger.warn((String)"Putting null key into map!!!", (String[])new String[0]);
            }
            if (this.resourceGroups.containsKey(key)) {
                Logger.warn((String)"Resource group identifier must be unique, but resource group with identifier {0} already exists!!!", (String[])new String[]{key});
            }
            this.resourceGroups.put(serviceGroup.getBaseUrl(), serviceGroup);
            return this;
        }

        public APIModelBuilder types(Map<String, Type> types) {
            this.types = types;
            return this;
        }

        public APIModelBuilder customInfo(String key, String value) {
            this.customInfo.put(key, value);
            return this;
        }

        public APIModel build() {
            return new APIModel(this.resourceGroups, this.types, this.customInfo.isEmpty() ? null : this.customInfo);
        }
    }
}

