/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.spi;

import org.projectnessie.services.spi.PagedResponseHandler;

public abstract class PagedCountingResponseHandler<R, E>
implements PagedResponseHandler<R, E> {
    private final int max;
    private int cnt;

    public PagedCountingResponseHandler(Integer maxRecords) {
        this.max = maxRecords != null ? maxRecords : Integer.MAX_VALUE;
    }

    public PagedCountingResponseHandler(Integer maxRecords, int strictMax) {
        this.max = Math.min(maxRecords != null ? Math.max(maxRecords, 0) : strictMax, strictMax);
    }

    protected abstract boolean doAddEntry(E var1);

    @Override
    public final boolean addEntry(E entry) {
        if (this.max > 0 && this.cnt >= this.max) {
            return false;
        }
        if (this.doAddEntry(entry)) {
            ++this.cnt;
            return true;
        }
        return false;
    }
}

