/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;

public final class RetriableAccessChecker {
    private final Supplier<BatchAccessChecker> validator;
    private Collection<Check> validatedChecks;
    private Map<Check, String> result;

    public RetriableAccessChecker(Supplier<BatchAccessChecker> validator) {
        Preconditions.checkNotNull(validator);
        this.validator = validator;
    }

    public BatchAccessChecker newAttempt() {
        return new Attempt();
    }

    private class Attempt
    extends AbstractBatchAccessChecker {
        private Attempt() {
        }

        @Override
        public Map<Check, String> check() {
            ArrayList<Check> currentChecks = new ArrayList<Check>(this.getChecks());
            if (RetriableAccessChecker.this.validatedChecks != null && RetriableAccessChecker.this.result != null && RetriableAccessChecker.this.validatedChecks.equals(currentChecks)) {
                return RetriableAccessChecker.this.result;
            }
            BatchAccessChecker checker = (BatchAccessChecker)RetriableAccessChecker.this.validator.get();
            currentChecks.forEach(checker::can);
            RetriableAccessChecker.this.result = checker.check();
            RetriableAccessChecker.this.validatedChecks = currentChecks;
            return RetriableAccessChecker.this.result;
        }
    }
}

