/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.services.authz.AccessCheckException;
import org.projectnessie.services.authz.Check;
import org.projectnessie.versioned.NamedRef;

public interface BatchAccessChecker {
    public Map<Check, String> check();

    default public void checkAndThrow() throws AccessCheckException {
        BatchAccessChecker.throwForFailedChecks(this.check());
    }

    public static void throwForFailedChecks(Map<Check, String> failedChecks) throws AccessCheckException {
        if (!failedChecks.isEmpty()) {
            throw new AccessCheckException(String.join((CharSequence)", ", failedChecks.values()));
        }
    }

    @CanIgnoreReturnValue
    public BatchAccessChecker can(Check var1);

    @CanIgnoreReturnValue
    public BatchAccessChecker canViewReference(NamedRef var1);

    @CanIgnoreReturnValue
    public BatchAccessChecker canCreateReference(NamedRef var1);

    @CanIgnoreReturnValue
    public BatchAccessChecker canAssignRefToHash(NamedRef var1);

    @CanIgnoreReturnValue
    public BatchAccessChecker canDeleteReference(NamedRef var1);

    @CanIgnoreReturnValue
    public BatchAccessChecker canReadEntries(NamedRef var1);

    @CanIgnoreReturnValue
    public BatchAccessChecker canReadContentKey(NamedRef var1, IdentifiedContentKey var2);

    @CanIgnoreReturnValue
    public BatchAccessChecker canListCommitLog(NamedRef var1);

    @CanIgnoreReturnValue
    public BatchAccessChecker canCommitChangeAgainstReference(NamedRef var1);

    @CanIgnoreReturnValue
    public BatchAccessChecker canReadEntityValue(NamedRef var1, IdentifiedContentKey var2);

    @CanIgnoreReturnValue
    public BatchAccessChecker canCreateEntity(NamedRef var1, IdentifiedContentKey var2);

    @CanIgnoreReturnValue
    public BatchAccessChecker canUpdateEntity(NamedRef var1, IdentifiedContentKey var2);

    @CanIgnoreReturnValue
    public BatchAccessChecker canDeleteEntity(NamedRef var1, IdentifiedContentKey var2);

    @CanIgnoreReturnValue
    public BatchAccessChecker canReadRepositoryConfig(RepositoryConfig.Type var1);

    @CanIgnoreReturnValue
    public BatchAccessChecker canUpdateRepositoryConfig(RepositoryConfig.Type var1);
}

