/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import java.util.function.Supplier;
import org.projectnessie.model.Content;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.server.store.BaseSerializer;
import org.projectnessie.server.store.proto.ObjectTypes;

public final class UnknownSerializer
extends BaseSerializer<Content> {
    public Content.Type contentType() {
        return Content.Type.UNKNOWN;
    }

    public int payload() {
        return 0;
    }

    @Override
    protected void toStoreOnRefState(Content table, ObjectTypes.Content.Builder builder) {
        throw new UnsupportedOperationException();
    }

    public Content.Type getType(ByteString onReferenceValue) {
        ObjectTypes.Content parsed = UnknownSerializer.parse(onReferenceValue);
        if (parsed.hasIcebergRefState()) {
            return Content.Type.ICEBERG_TABLE;
        }
        if (parsed.hasIcebergViewState()) {
            return Content.Type.ICEBERG_VIEW;
        }
        if (parsed.hasDeltaLakeTable()) {
            return Content.Type.DELTA_LAKE_TABLE;
        }
        if (parsed.hasNamespace()) {
            return Content.Type.NAMESPACE;
        }
        throw new IllegalArgumentException("Unsupported on-ref content " + String.valueOf(parsed));
    }

    public boolean requiresGlobalState(ByteString content) {
        ObjectTypes.Content parsed = UnknownSerializer.parse(content);
        switch (parsed.getObjectTypeCase()) {
            case ICEBERG_REF_STATE: {
                return !parsed.getIcebergRefState().hasMetadataLocation();
            }
            case ICEBERG_VIEW_STATE: {
                return !parsed.getIcebergViewState().hasMetadataLocation();
            }
        }
        return false;
    }

    @Override
    protected Content valueFromStore(ObjectTypes.Content content, Supplier<ByteString> globalState) {
        switch (content.getObjectTypeCase()) {
            case DELTA_LAKE_TABLE: {
                return UnknownSerializer.valueFromStoreDeltaLakeTable(content);
            }
            case ICEBERG_REF_STATE: {
                return UnknownSerializer.valueFromStoreIcebergTable(content, new BaseSerializer.IcebergMetadataPointerSupplier(globalState));
            }
            case ICEBERG_VIEW_STATE: {
                return UnknownSerializer.valueFromStoreIcebergView(content, new BaseSerializer.IcebergMetadataPointerSupplier(globalState));
            }
            case NAMESPACE: {
                return UnknownSerializer.valueFromStoreNamespace(content);
            }
            case UDF: {
                return UnknownSerializer.valueFromStoreUDF(content);
            }
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(content.getObjectTypeCase()));
    }
}

