/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableDiffEntry;
import org.projectnessie.model.ImmutableDiffResponse;
import org.projectnessie.model.PaginatedResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ser.Views;

@Schema(type=SchemaType.OBJECT, title="DiffResponse")
@JsonSerialize(as=ImmutableDiffResponse.class)
@JsonDeserialize(as=ImmutableDiffResponse.class)
@Value.Immutable
public interface DiffResponse
extends PaginatedResponse {
    public static ImmutableDiffResponse.Builder builder() {
        return ImmutableDiffResponse.builder();
    }

    public List<DiffEntry> getDiffs();

    @Nullable
    @jakarta.annotation.Nullable
    @JsonView(value={Views.V2.class})
    public Reference getEffectiveFromReference();

    @Nullable
    @jakarta.annotation.Nullable
    @JsonView(value={Views.V2.class})
    public Reference getEffectiveToReference();

    @JsonSerialize(as=ImmutableDiffEntry.class)
    @JsonDeserialize(as=ImmutableDiffEntry.class)
    @Value.Immutable
    public static interface DiffEntry {
        @Value.Parameter(order=1)
        public ContentKey getKey();

        @Nullable
        @jakarta.annotation.Nullable
        @Value.Parameter(order=2)
        public Content getFrom();

        @Nullable
        @jakarta.annotation.Nullable
        @Value.Parameter(order=3)
        public Content getTo();

        public static DiffEntry diffEntry(ContentKey key, Content from) {
            return DiffEntry.diffEntry(key, from, null);
        }

        public static DiffEntry diffEntry(ContentKey key, Content from, Content to) {
            return ImmutableDiffEntry.of(key, from, to);
        }
    }
}

